                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Problems">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.3.88.11.83.103" assigningAuthorityName="HITSP/C83"/>
                                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.6" assigningAuthorityName="IHE PCC"/>
                                <templateId root="2.16.840.1.113883.10.20.1.11" assigningAuthorityName="HL7 CCD"/>
                                <code code="11450-4" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Problem list"/>
                                <title>Problems</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Problems/a:Problem">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <table>
                                                            <tbody>
                                                                <xsl:apply-templates select="a:DateTime"/>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
														<xsl:attribute name="ID">
															<xsl:value-of select="a:CCRDataObjectID"></xsl:value-of>
														</xsl:attribute>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Problems/a:Problem">
                                    <entry typeCode="DRIV">
                                        <act classCode="ACT" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.10.20.1.27"/>
                                            <!-- Problem act template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <code nullFlavor="NA"/>

                                            <xsl:call-template name="ccdPerformer">
                                                <xsl:with-param name="ccrActorReference" select="a:Source/a:Actor"/>
                                            </xsl:call-template>

                                            <entryRelationship typeCode="SUBJ">
                                                <observation classCode="OBS" moodCode="EVN">
                                                    <templateId root="2.16.840.1.113883.10.20.1.28" assigningAuthorityName="CCD"/>
                                                    <!--Problem observation template-->
						    <templateId root="2.16.840.1.113883.3.249.11.100.8"/>	

                                                    <!-- <id> -->
                                                    <xsl:call-template name="ccdID">
                                                        <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                                        <xsl:with-param name="suffix"></xsl:with-param>
                                                    </xsl:call-template>
                                                   <code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
<!--SEE IF THIS FIXES OUR PROBLEM-->
                                               <!-- <code xsi:type="CE" code="55607006" displayName="Problem" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>-->
                                                    <statusCode code="completed"/>
                                                  <!-- <text>
                                                       <reference>
                                                            <xsl:attribute name="value">
                                                                <xsl:text>#</xsl:text>
                                                                <xsl:value-of select="a:CCRDataObjectID"/>
                                                            </xsl:attribute>
                                                        </reference>
                                                    </text>-->

                                                     <xsl:call-template name="ccdDateTime">
                                                        <xsl:with-param name="dt" select="a:DateTime"/>
                                                    </xsl:call-template>

                                                    <xsl:call-template name="ccdCodedValue">
                                                        <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                    </xsl:call-template>

                                                    <xsl:call-template name="ccdStatus">
                                                        <xsl:with-param name="ccrStatus" select="a:Status"/>
                                                    </xsl:call-template>
                                                </observation>
                                            </entryRelationship>

                                        </act>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
