<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="cda.xsl"?>

<!--
Conversion of CCR to Level 3 CCD

Orginal Author:   	Ken Miller
Solventus LLC
ken.miller@solventus.coms

Contributors:
Richard Braman, EHR Doctors, Inc rbraman@ehrdoctors.com
George Lilly (WorldVistA glilly@glilly.net)
Nancy Antracite, WorldVistA
xxxx - Oroville Hospital

Date: 	2010-05-5
Version: 	0.1

License :

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see http://www.gnu.org/licenses.

-->
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:a="urn:astm-org:CCR" xmlns:date="http://exslt.org/dates-and-times"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a date">
    <xsl:import href="./templates/cdavocablookup.xsl"/>
    <xsl:import href="./templates/hl7oidlookup.xsl"/>
    <xsl:import href="./templates/code.xsl"/>
    <xsl:import href="./templates/actor.xsl"/>
    <xsl:import href="./templates/datetime.xsl"/>
    <xsl:import href="./templates/problemDescription.xsl"/>

    <xsl:output method="xml" encoding="utf-8" version="1.0" indent="yes"/>
    <xsl:template match="/">
<!--WV Added new munltiple documentation of added have to do with encounter times, etc.-->

<!--
********************************************************
CDA Header
********************************************************
-->

<!--
******************
Document Information
**********************
-->
<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 CDA.xsd">
	<!-- Created with XML Copy Editor  Open Source Sourceforge project. -->
<!--WVP This is the clinical document type ID-->
  <realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- QRDA Category I generic template ID. -->
	<!--WVP these next two lines are fixed-->
	<templateId root="2.16.840.1.113883.10.20.12" />
	<!--only in the july spec so not sure if it should be here-->
	<templateId root="2.16.840.1.113883.3.249.11.100.1"/>
	<!--WVV 2.16.840.1.113883.3.543 is fixed and is the beginninng of WorldVistAs OID, change the extension for a new document and the version for changes to this one-->
	
	
	<!--Script replaces UUID each time if the version number is 1-->
	<id root="2.16.840.1.113883.3.543" extension="@@@UUID-DOC@@@"/>

             <!--   <xsl:attribute name="root">
                    <xsl:value-of select="/a:ContinuityOfCareRecord/a:CCRDocumentObjectID"></xsl:value-of>
                </xsl:attribute>
            </id>-->
		 <!--WVP next two lines fixed-->
	<code code="55182-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Quality Measure Report"/>
	<title>QRDA Incidence Report</title>
		<!--WVV time-->
	<effectiveTime value="20100703"/>
		<!--WVP for next two lines-->
  <confidentialityCode codeSystem="2.16.840.1.113883.5.25" code="N"/>
  <languageCode code="en-US"/>
  <!--WV? Don't change this in the document set we are working on-->
  <setId root="2.16.840.1.113883.3.543" extension="@@@UUID-SET@@@"/>
	 <versionNumber value="1"/>
  <!--WVP  I made one up but we will have to have an OID for the Clincal Document SET which we will make up for ourselves eventually-->
  
 <!--
 *******************
 Patient Information
 ****************
 -->
	<!-- This is the patient for which the report is describing. -->
	<recordTarget>
<patientRole>
                <xsl:call-template name="ccdPatientRole">
                    <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Patient[1]/a:ActorID"/>
                </xsl:call-template>
                </patientRole>
	</recordTarget>

<!--
*****************************
Author
**************
-->
	<!-- This example assumes the doctor is creating the report and it is Required.  -->
	<author>
	  <!--WVV Edit time has to be precise at least to the day-->
		<time value="20100703" />
		<assignedAuthor>
		  <!--WVP eventually id this is required, the root is fixed -->
		  <!--andn the extension is the SOFTWARE version number assigned by CMS to WV EHR-->
			<id root="2.16.840.1.113883.3.249.6" extension="100001" />
			<!--WVVassignedPerson not required-->
			<assignedPerson>
				<name>
				  <!--WV Edit-->
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? id root is OID for the organization so I made one up for this document set-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedAuthor>
	</author>
		<!-- The reporting healthcare facility is represented using the CCD "Source of Information" construct, via the Informant participant. -->
	<informant>
	   <assignedEntity>
      <!--WV this null flavor is required as is-->
			<id nullFlavor="NA"/>
			<representedOrganization>
				<!--WV root is the OID of the organization.  ID is required but name is not and id is OID stated earlier-->
        <id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>World VistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</informant>

	<!-- This example assumes that the institution responsible for the data is serving as custodian. -->
	<!--WV This element is required as is the sSD which is not stated if it is an OID but assumed it is-->
	<!--WV Name is not required, only ID is required.-->
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>

	<!-- In this example, the author is also serving as legal authenticator. -->
	<!--WV section is this is not required-->
<legalAuthenticator>
		<time value="20100703" />
		<!--WV the signature code of S is required-->
		<signatureCode code="S" />
		<assignedEntity>
      <!--WV document does not specify the requirements of the id but it is required-->
      <!--WVP and the sample suggests it is the number below and extension is ???-->
			<id root="2.16.840.1.113883.3.543" extension="111111" />
			<assignedPerson>
				<name>
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? and is fixed for the WorldVistA Test Clinic in this submitted document series-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</legalAuthenticator>
	
	
	
	<!--Added to sample as it is new since 2008-->
	<!--WVP permanent for participant in the primary care provider participant-->
<!--WVP performer type codes are numerous but PRF is performer or the person who did it-->
	<participant typeCode="PRF">
	  <!--WVP required as is for function-->
	  <!-- WVP I believe PCP is primary care provider but not sure-->
	  <functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88"/>
	  <!--WVP Associated Entity is required ti be there with this PROV-->
	  <associatedEntity classCode="PROV">
	    <!--WV? OID of the provider fixed for this series of documents-->
	    <id root="2.16.840.1.113883.3.249.6" extension="111111" />
	    <!--WV associated person is not required so presumabley the code will suffice not sure??-->
	    <associatedPerson>
	      <name>
	        <prefix>Dr.</prefix>
	        <given>Nancy</given>
	        <family>Anthracite</family>
        </name>
	    </associatedPerson>
    </associatedEntity>
	</participant>
	
	<!--The service event is the encounter that describes tehe encunter as well as the provider, location and time-->
	<!--!There can be one or more documentation elements depending on the number of encounters during the reporting period-->
	<!--WVV IMPORTANT!! The encounter codeds are recorded here-->
	<!-- They are in appendix B of the downloadable resource document-->
	<!-- Each documentation of is a single service event-->
	
<!--Occurence of Measures episode documention-->
<!--Like an encounter section only for QRDA-->
<!--Same doctor, same clinic, different date and different enconter code-->
	
	
	<!--First Visit documentationOf section-->
<!--DOCUMENTATIONOFSECTION-->

	<!-- 
********************************************************
CDA Body
********************************************************
-->
 <component>
 	<structuredBody>
         <MeasuresSection/>
	<!--***********the following two component and sections tags will have to be removed when the measures section is put back in -->
          <component>
		<section>
		<component>
		<section>
                <!--
                  ********************************************************
                  Patient Data 
                  ********************************************************
                 -->
                 <component>
                  <section>
                    <code code="55188-7" codeSystem="2.16.840.1.113883.6.1"/>
                    <title>Patient Data</title>

