#!/bin/bash

#there are many reads and comments in this document for debugging
#This scipt requires a provider organization file for each provider to be in the directory, and AllM1EncounterCodes.txt,
#First fix all of the Measures sections in all of the files
#The following files must be in the same directory as the QRDA files being processed:
#MeasuresAndReportingParametersWithVariables.xml
#MEASURES-BY-PATIENT.txt
#This script which is FixMeasuresSection.sh

#PAT_*_QRDA_V1_0_0-11-08-2010_19.xml is assumged to be the file
#TEMPORARY
#bash FixMeasuresSection.sh


#Find out which files to edit and assign them to the variable "MyFile". As you can see, here I loop through particular files in the same directory with this script

for MyFile in $(ls PAT_*_QRDA_V1_0_0-11-10-2010_16.xml)
do


#Process the problem section by calling the function FunctionProcessProblemSection
#You will need the following files
#   LineNumberDownFunction
#   AllI9ProblemCodes.txt
#   LineNumberUpDownFunction
#   This file FunctionProcessProblemSection
#echo "MyFile is $MyFile"
#source FunctionProcessProblemSection
#FunctionProcessProblemSection $MyFile
#cp $MyFile $MyFile"BU"
#Replace where is just says SSN for the patient with the  SSN ID HL7 number
#since this is a medicare patient, no privacy violation as that will also appear in the Payer's section

echo "xml files are in the directory"
pwd
#read

#replace the @@@UUID-DOC@@@,@@@UUID-SET@@@ and @@@UUID-PAYER@@@ with UUIDs
#should probably do that in the problem section as well with WV HL7 ID as root and UUID as an extension for now

VerNum=$(grep versionNumber "$MyFile"|awk -F\" '{print $2}')
echo "$VerNum"

if [ "1" = "$VerNum" ]
then
  #uuid is a Linux command that generates a new uuid
  u=$(uuid)
  sed -i s/'@@@UUID-DOC@@@'/$u/ $MyFile

  sed -i s/'@@@UUID-SET@@@'/$u/ $MyFile
  sed -i s/'@@@UUID-PAYER@@@'/$u/ $MyFile

else 
  echo "UUIDs should remain unchanged because this is not the first version of this document"

fi
echo "replace UUID site markers"
u=""
VerNum=""
#read


#make sure <state></state> is no longer than two

echo "Fix the state line length"

sed -i 's/Alabama/AL/gI' $MyFile
sed -i 's/Alaska/AK/gI' $MyFile
sed -i 's/Arizona/AZ/gI' $MyFile
sed -i 's/Arkansas/AR/gI' $MyFile
sed -i 's/California/CA/gI' $MyFile
sed -i 's/Colorado/CO/gI' $MyFile
sed -i 's/Connecticut/CT/gI' $MyFile
sed -i 's/Delaware/DE/gI' $MyFile
sed -i 's/District of Columbia/DC/gI' $MyFile
sed -i 's/Florida/FL/gI' $MyFile
sed -i 's/Georgia/GA/gI' $MyFile
sed -i 's/Hawaii/HI/gI' $MyFile
sed -i 's/Idaho/ID/gI' $MyFile
sed -i 's/Illinois/IL/gI' $MyFile
sed -i 's/Indiana/IN/gI' $MyFile
sed -i 's/Iowa/IA/gI' $MyFile
sed -i 's/Kansas/KS/gI' $MyFile
sed -i 's/Kentucky/KY/gI' $MyFile
sed -i 's/Louisiana/LA/gI' $MyFile
sed -i 's/Maine/ME/gI' $MyFile
sed -i 's/Maryland/MD/gI' $MyFile
sed -i 's/Massachusetts/MA/gI' $MyFile
sed -i 's/Michigan/MI/gI' $MyFile
sed -i 's/Minnesota/MN/gI' $MyFile
sed -i 's/Mississippi/MS/gI' $MyFile
sed -i 's/Missouri/MO/gI' $MyFile
sed -i 's/Montana/MT/gI' $MyFile
sed -i 's/Nebraska/NE/gI' $MyFile
sed -i 's/Nevada/NV/gI' $MyFile
sed -i 's/New Hampshire/NH/gI' $MyFile
sed -i 's/New Jersey/NJ/gI' $MyFile
sed -i 's/New Mexico/NM/gI' $MyFile
sed -i 's/New York/NY/gI' $MyFile
sed -i 's/North Carolina/NC/gI' $MyFile
sed -i 's/North Dakota/ND/gI' $MyFile
sed -i 's/Ohio/OH/gI' $MyFile
sed -i 's/Oklahoma/OK/gI' $MyFile
sed -i 's/Oregon/OR/gI' $MyFile
sed -i 's/Pennsylvania/PA/gI' $MyFile
sed -i 's/Rhode Island/RI/gI' $MyFile
sed -i 's/South Carolina/SC/gI' $MyFile
sed -i 's/South Dakota/SD/gI' $MyFile
sed -i 's/Tennessee/TN/gI' $MyFile
sed -i 's/Texas/TX/gI' $MyFile
sed -i 's/Utah/UT/gI' $MyFile
sed -i 's/Vermont/VT/gI' $MyFile
sed -i 's/Virginia/VA/gI' $MyFile
sed -i 's/Washington/WA/gI' $MyFile
sed -i 's/West Virginia/WV/'gI $MyFile
sed -i 's/Wisconsin/WI/gI' $MyFile
sed -i 's/Wyoming/WY/gI' $MyFile
sed -i 's/American Samoa/AS/gI' $MyFile
sed -i 's/Guam/GU/gI' $MyFile
sed -i 's/Northern Mariana Islands/MP/gI' $MyFile
sed -i 's/Puerto Rico/PR/gI' $MyFile
sed -i 's/Virgin Islands/VI/gI' $MyFile
sed -i 's/West VA/WV/gI' $MyFile
sed -i 's/N Carolina/NC/gI' $MyFile
sed -i 's/N Dakota/ND/gI' $MyFile
sed -i 's/S Carolina/SC/gI' $MyFile
sed -i 's/S Dakota/SD/gI' $MyFile
sed -i 's/Puerto Rico/PR/gI' $MyFile
sed -i 's/Virgin Islands/VI/gI' $MyFile
sed -i 's/"W. VA"/WV/gI' $MyFile
sed -i 's/"N. Carolina"/NC/gI' $MyFile
sed -i 's/"N. Dakota"/ND/gI' $MyFile
sed -i 's/"S. Carolina"/SC/gI' $MyFile
sed -i 's/"S. Dakota"/SD/gI' $MyFile
sed -i 's/"R.I."/RI/gI' $MyFile


#Fix the state entries

(grep -n '<state>' $MyFile |awk  -F\: '{print $1}') >> statetags.txt

for i in $(cat statetags.txt);
do
StateLineLength=$(sed -n "$i"p "$MyFile" | sed 's/^[ \t]*//' |awk '{print length}')

echo "StateLineLength is $StateLineLength"
if [ ! "17" = "$StateLineLength" ]
then

cat -n $MyFile | grep '<state>';echo "$MyFile"
echo "Urgent there is a problem with the <state> tag in $MyFile"
#read

fi
done

StateLineLength=""
rm -rf statetags.txt #UNCOMMENT THIS!!!

echo "$MyFile"
a1=$(grep -n \"SSN\" $MyFile | awk -F\" '{print $2}'); echo "$a1"
echo "$a1 is the line with SSN on it"
sed -i s/@@SSN@@/"$a1"/ $MyFile
sed -i 's/SSN/2.16.840.1.113883.4.1/' $MyFile
a1=""


echo "SSN code added"
echo "About to start fixing the problem section"
#read
#PROBLEM SECTION FUNCTION REMOVED




#PROBLEM SECTION 1 FIX - TEMPLATE
#Add the added template line after 2.16.840.1.113883.10.20.1.50
sed -in /"2.16.840.1.113883.10.20.1.50"/s/$/"\\n<templateId root=\"2.16.840.1.113883.3.249.11.100.12\"\\/>"/ "$MyFile"
cat -n "$MyFile" | grep "3.249.11.100.12"

#read
#PROBLEM FIX 2 - TABLE
#Remove the table in the beginning of the section
if grep -q "11450-4" "$MyFile" >>/dev/null
then
ProblemSectionKey=$(grep -n "11450-4" "$MyFile" | awk -F: '{print $1}')
grep -n "2.16.840.1.113883.10.20.1.27" "$MyFile" | awk -F: '{print $1}' >> Problem27TemplateLines.txt
#read
startline="$ProblemSectionKey"
endline="$(head -1 Problem27TemplateLines.txt)"
echo "$startline is startline"
echo "$endline is endline"
cat -n "$MyFile" | grep '<table>'
#Remove the table at the beginning of the problem section but leaves <text/>
sed -in "$startline,$endline{ s/<text>/<text\/>\n<text>/ }" "$MyFile"
sed -in "$startline,$endline{ /<text>/,/<\/text>/d }" "$MyFile"

# this in an example of one that works
#sed -in "$startline,$endline{ /<table>/,/<\/table>/d }" M1-PAT_100839_QRDA_V1_0_0.xml
cat -n "$MyFile" | grep '<table>'
echo "Done removing the table"
startline=""
endline=""
rm -rf Problem27TemplateLines.txt
rm -rf MyValueLinesInProblems.txt
fi
#PROBLEM SECTION FIX 3 - TEXT TAGS
#Remove <text> </text> section near effectiveTime
#read

index="0"
grep -n "2.16.840.1.113883.3.249.11.100.8" $MyFile | awk -F: '{print $1}' >> MyTextLinesKeysProblems.txt
for i in $(cat MyTextLinesKeysProblems.txt);
do
startline="$(($i+$index))"
endline="$(($i+$index+10))"
sed -in "$startline,$endline{ /<text>/,/<\/text>/d }" "$MyFile"
index="$((index-3))"
done
index=""
starline=""
endline=""
rm -rf MyTextLinesKeysProblems.txt
echo "done removing <text>"
#read

#PROBLEM SECTION 4 FIX - REMOVE BAD VALUE LINE
#remove the value tags after the 2.16.840.1.113883.10.20.1.50 enty 
index="0"
echo "value Lines in Problems about to be written to the file"
#grep -n "2.16.840.1.113883.10.20.1.50" $MyFile | awk -F: '{print $1}'
grep -n "2.16.840.1.113883.10.20.1.50" $MyFile | awk -F: '{print $1}' >> MyValueLinesInProblems.txt
for i in $(cat MyValueLinesInProblems.txt);
do
startline="$((i+index))"
endline="$(($i+index+8))"
#sed -in "$startline,$endline{ /<value>/,/<\/value>/d }" "$MyFile"
sed -in "$startline,$endline{ /<value>/,/<\/value>/d }" "$MyFile"
echo "a value line was deleted from the $startline area"
index="$((index-3))"
done
index=""
starline=""
endline=""
cat MyValueLinesInProblems.txt
rm -rf MyValueLinesInProblems.txt 
echo "done removing bad value lines"
#read

#PROBLEM SECTION 5 FIX - ADD GOOD VALUE LINE

#Put in a good value line if there are bad ones

cat -n "$MyFile" | grep "55561003"; echo "greped 55561003"
cat -n "$MyFile" | grep "2.16.840.1.113883.3.249.11.100.12";echo "grepped 2.16.840.1.113883.3.249.11.100.12"
cat -n "$MyFile" | grep "2.16.840.1.113883.10.20.1.50"; echo "grepped 2.16.840.1.113883.10.20.1.50"
echo " about to add xsi value lines with sed"
#read

#sed -in '/"2.16.840.1.113883.10.20.1.50"/{n;n;n;s/$/\n<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1. 113883.6.96" displayName="Active" codeSystemName="SNM" \/>/}' "$MyFile"
sed -in '/"2.16.840.1.113883.10.20.1.50"/{N;N;N;s/$/\n<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96" displayName="Active" codeSystemName="SNM" \/>/}' "$MyFile"
#echo "value Lines in Problems about to be written to screen and then the file"
#grep -n "2.16.840.1.113883.10.20.1.50" $MyFile | awk -F: '{print $1}' 
#grep -n "2.16.840.1.113883.10.20.1.50" $MyFile | awk -F: '{print $1}' >> MyValueLinesInProblems.txt
#for i in $(cat MyValueLinesInProblems.txt)
#do 
#  sed -in "$i","$((i+6))"p "$MyFile"
#done
#rm -rf MyValueLinesInProblems.txt
echo "done adding good value line"
#read

#PROBLEM #6 - XSI PROBLEM
#Fix the missing xsi:code value lines
#Fix any wrong value elements in the problem section
#I don't think there are any

#cat MyStatusTemplates.txt
#echo "above checking the MyStatusTemplates.txt file content"
#read

echo "issuing the sed command to delete the buffer"

sed -e 'd' /home/nancy/CCR-Template/MyFile.txt
#read
Startline="$(cat "$MyFile" | grep -n "11450-4" | awk -F: '{print $1}')"
grep -n "2.16.840.1.113883.10.20.1.50" "$MyFile" | awk -F: '{print $1}' >> MyStatusTemplates.txt
Endline="$(tail -1 MyStatusTemplates.txt)"
cat -n "$MyFile" | grep '<value code'
echo "Endline is $Endline"
echo "startline is $Startline"

#echo 'about to run the sed -fix the xsi code"
#sed -in "158,401{ s/<value code/<value xsi:type=\"CD\" code/ }" "$MyFile"
sed -in "$Startline,$Endline{ s/<value code/<value xsi:type=\"CD\" code/ }" "$MyFile"
sed -in "$Startline,$Endline{ s/<value displayName/<value xsi:type=\"CD\" displayName/ }" "$MyFile"

StartLine=""
Endline=""
rm -rf MyStatusTemplates.txt
echo "done checking for bad value lines"
#read


#Done fixing Problem Section**********

#Fix that dummy number they gave us with the right entry for Matt or Nancy
echo "if grep -q Nancy $MyFile then"
if grep -q Nancy $MyFile then
then
 sed -i 's/6558574524/1558574525/' $MyFile
else
 sed -i 's/6558574524/1124022827/' $MyFile
fi 

echo "read change NPIs for Matt and Nancy"
#read
#Line adminstrative gender code is on
a=$(grep -n birthTime $MyFile|awk -F: '{print $1}')

sed -i 's/AdministrativeGender\"\ codeSystem=\"\"/AdministrativeGender\"\ codeSystem=\"2.16.840.1.113883.5.1\"/' $MyFile
#sed -i 's/AdministrativeGender\"\ codeSystem=\"\"/codeSystem=\"2.16.840.1.113883.5.1\"/' $MyFile
#sed -i 's/administrativeGenderCode displayName=\"FEMALE\"/administrativeGenderCode/' $MyFile
#sed -i 's/administrativeGenderCode displayName=\"MALE\"/administrativeGenderCode/' $MyFile

#now that the adminstrativeGenderCode is fixed, save it in a variable
agc=$(grep AdminstrativeGender $MyFile)

echo "Moving header including up to birthTime into MyNewFile.xml"
#Send the part of the file up to and including administrativeGenderCode and birthTime to MyNewFile
head -"$a" $MyFile >> MyNewFile.xml

a=""
agc=""
#read
#the race and  ethnicity will eventually  come from the CCR Social History
#orde needs to be adminGender, birthTIme, race, ethnicity
#Now add the administrative gender


#now add the race code line to my new file
#right now everybody is native Hawaiian until we get this fixed!
#Plan to use only the existing VistA codes which match meaningful use
echo '<raceCode code="2076-8" codeSystem="2.16.840.1.113883.5.104"/>' >> MyNewFile.xml
echo '<ethnicGroupCode code="2186-5" codeSystem="2.16.840.1.113883.5.50"/>' >> MyNewFile.xml
echo '</patient>' >> MyNewFile.xml

tail -6 MyNewFile.xml

#the race and  ethnicity that will eventually  come from the CCR Social History
echo "fix administrativeGender, birthTime, raceCode and ethnicGroup"
#read
#copy the lines with the birthTime and  <patient> and  into the file in tieir proper place
#by pulling their locatin from the original file relative to the administrativeGenderCode line


#The providerOrganization sectiono is missing entrirely so put it in from these hard coded files for Matt and Nancy
#in their proper place right after the </patient tag

if grep -q Nancy $MyFile
 then 
  cat NancysProviderOranization.txt >> MyNewFile.xml
else
 cat MatthewsProviderOranization.txt >> MyNewFile.xml
fi
#this just adds a line feed to MyNewFile.xml
echo >> MyNewFile.xml

echo "read Provider organizaton added"
#read
#put the document beginning with /patientRole until the </participant> tag that is 2 lines after the only incidence of </associated person just before the <documentationOf> into MyNewFile.xml
d=$(grep -n "/patientRole" $MyFile|awk -F: '{print $1}');echo $d
e=$(($d+1));echo $e
f=$(grep -n "/associatedPerson" $MyFile|awk -F: '{print $1}');echo $f
g=$(($f+2));echo $g
cat $MyFile | sed -n $d,$g"p" >> MyNewFile.xml
#now add in the </patient role and </recordTarget>
echo "read /patientRole to /participant Person added"
#read
#now add the documentation of pulling the data from the encounter procedures later in the  document. Searches for Encounters that are 
#appropriate for the measure which will be in Encounter.txt 

#!!!!ADD MATT HERE
for i in $(cat AllEncounterCodes.txt); 
do
  
  if [ "0" = "$(grep -q "$i" "$MyFile";echo "$?")" ] 
    then 
      echo $(grep -n "$i" "$MyFile" | awk -F: '{print $1}') >> Encounters.txt
      echo "$i"
      echo "above code added"
   fi
 done
cat "Encounters.txt"
#read

if [ -f Encounters.txt ]
  then
  for i in $(cat Encounters.txt);
    do
        echo      
	echo "<documentationOf>" >> MyNewFile.xml
	echo "<serviceEvent>" >> MyNewFile.xml
	cat $MyFile | sed -n $i"p" >> MyNewFile.xml
	x=$(($i+5)); echo $x
	y=$(($i+8)); echo $y
	#echo "sed -n "$x","$y"p >> MyNewFile.xml"
	cat "$MyFile" | sed -n "$x","$y"p >> MyNewFile.xml
	cat EndDocumentationOfSectionNancy.txt >> MyNewFile.xml
	#added a line feed
	echo >> MyNewFile.xml
	#for testing print out the last 10 lines to the screen
	tail MyNewFile.xml
    done
   else echo "$MyFile" >> FilesWithoutEncounters.txt
  fi
tail MyNewFile.xml
rm -rf Encounters.txt
y=""
x=""

echo "read documentationOf added and each section of that tailed -10"
#read
#read
#takes the low value date and puts it in the high value if the the is a nullFlavor there and it also corrects the dates by adding a 0 
#in the 5th digit position if the date is 7 long instead of 8 and a zero in the 5th and next to the last position if the date is 6 long (ie,too short in either the low or high value)  The latter is fixed now so it can be trimmed out - soon  All dates and times are 8 or more
echo "<component>" >> MyNewFile.xml
p=$(grep -n '<structuredBody>' $MyFile | awk -F: '{print $1}')
q=$(grep -n '</ClinicalDocument>' $MyFile | awk -F: '{print $1}')
cat "$MyFile" | sed -n "$p","$q"p >> MyNewFile.xml
# take out <high nullFlavor="UNK"/> and replace it with the same value that is in low value everywhere it appears

grep -n '<high nullFlavor="UNK"/>' MyNewFile.xml | awk -F: '{print $1}' >> NullFlavorTimes.txt
#NullFlavorTimes.txt has the line numbers
for i in $(cat NullFlavorTimes.txt);
 do
    #low value is one line above the high value with the nullFlavor, so get the date as it is
    l=$(($i-1));echo $l
    m=$(sed -n "$l"p MyNewFile.xml) 
    n=$(echo "$m" | awk -F\" '{print $2}')
    u=$(echo "${#n}")
    #fixes the date in low value if it is 7 long
    if [ $u = 7 ]
    then
    v=$(echo $n |cut -c1-4)
    w=$(echo $n |cut -c5-7)
    j=$(echo $v"0"$w);echo $n
    sed -i "$l"s/"$n"/"$j"/ MyNewFile.xml
    n="$j"
    #fixes the date if it is 6 long
    elif [ $u = 6 ] 
    then
    v=$(echo $n |cut -c1-4)
    w=$(echo $n |cut -c5)
    x=$(echo $n |cut -c6)
    j=$(echo $v"0"$w"0"$x);echo $n
    sed -i "$l"s/"$n"/"$j"/ MyNewFile.xml
    n="$j"
    fi
    #now puts the low value corrected date in the high value
    o="value="\""$n"\"""
    echo $o
    echo $i
    #echo "sed -i "$i"s/nullFlavor=\"UNK\"/$o/ MyNewFile.xml"
    sed -i "$i"s/'nullFlavor=\"UNK\"'/"$o"/ MyNewFile.xml
done
rm -rf NullFlavorTimes.txt

l=""
m=""
n=""
u=""
v=""
w=""
j=""
o=""
i=""
echo "read NullFlavorTimes Fixed"
#
#read


#THIS NEEDS TO BE REPLACED WITH CUTTING OUT PROCEDURES NOT IN THE DOWNLOADABLE RESOURCE TABLE
#CODE FOR DELETING PROCEDURES WAS HERE AND IS NOW IN CodeForDeletingProcedures.txt

#Replace anything with SNOMED or SNOMED-CT with SNM and replace anything with ICD9CM with I9 and and replace where it says codeSystem="" in the problem list with codeSysetm="2.16.840.1.113883.6.103"
#in lines that contain ICD9CM, replace codeSystem="" with codeSystem="2.16.840.1.113883.6.103"
sed -i '/ICD9CM/s/codeSystem=\"\"/codeSystem=\"2.16.840.1.113883.6.103\"/' MyNewFile.xml
sed -i 's/SNOMED-CT/SNM/' MyNewFile.xml 
sed -i 's/ICD9CM/I9/' MyNewFile.xml
sed -i 's/ICD9/I9/' MyNewFile.xml
sed -i 's/SNOMED/SNM/' MyNewFile.xml


#Now put out a new file that has the same name as the original with Ver2 at the end which will contain the corrected header
echo "replace the codes with their proper names"
#read


cp MyNewFile.xml $(echo $MyFile | echo $(awk -F. '{print $1}')"Ver2.xml")
#mv MyNewFile.xml $(echo $MyFile | echo $(awk -F. '{print $1}')"Ver2.xml")
if grep -q 30954-2 MyNewFile.xml
then
echo "$MyFile contains results" >> FilesWithResults.txt
echo "$MyFile contains results" 
fi
rm -rf MyNewFile.xml
rm -rf MyNewFile.xmln
echo "this is the end"
#read
echo "end $MyFile"
done

echo "read FilesWithResults.txt has the names of files for running the results script"
#read
exit
