CCRMEDS ; WV/CCDCCR/SMH,CJE,GPL - CCR/CCD PROCESSING FOR MEDICATIONS ;08/24/08
   ;;0.1;CCDCCR;;JUL 16,2008;
   ; Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
   ; General Public License See attached copy of the License.
   ; 
   ; This program is free software; you can redistribute it and/or modify
   ; it under the terms of the GNU General Public License as published by
   ; the Free Software Foundation; either version 2 of the License, or
   ; (at your option) any later version.
   ; 
   ; This program is distributed in the hope that it will be useful,
   ; but WITHOUT ANY WARRANTY; without even the implied warranty of
   ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   ; GNU General Public License for more details.
   ; 
   ; You should have received a copy of the GNU General Public License along
   ; with this program; if not, write to the Free Software Foundation, Inc.,
   ; 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
   ;
   W "NO ENTRY FROM TOP",!
   Q
   ;
EXTRACT(INXML,DFN,OUTXML) ; EXTRACT MEDICATIONS INTO PROVIDED XML TEMPLATE
   ;
   ; INXML AND OUTXML ARE PASSED BY NAME SO GLOBALS CAN BE USED
   ; INXML WILL CONTAIN ONLY THE MEDICATIONS SECTION OF THE OVERALL TEMPLATE
   ; 
   ; MEDS is return array from RPC.
   ; MAP is a mapping variable map (store result) for each med
   ; MED is holds each array element from MEDS(J), one medicine
   ; J is a counter.
   ;
   ; RX^PSO52API is a Pharmacy Re-Enginnering (PRE) API to get all
   ; med data available.
   ; http://www.va.gov/vdl/documents/Clinical/Pharm-Outpatient_Pharmacy/phar_1_api_r0807.pdf
   ; Output of API is ^TMP($J,"SUBSCRIPT",DFN,RXIENS).

   N MEDS,MAP
   K ^TMP($J)
   D RX^PSO52API(DFN,"CCDCCR")
   M MEDS=^TMP($J,"CCDCCR",DFN)
   ; @(0) contains the number of meds.
   ; If there are no meds (@(0)=0), we quit.
   I 'MEDS(0) S @OUTXML@(0)=0 QUIT  
   I DEBUG ZWR MEDS
   N RXIEN S RXIEN=0
   F  S RXIEN=$O(MEDS(RXIEN)) Q:RXIEN=""  D  ; FOR EACH MEDICATION IN THE LIST
   . I DEBUG W "RXIEN IS ",RXIEN,!
   . S MAP=$NA(^TMP("GPLCCR",$J,"MEDMAP",J))
   . K @MAP
   . I DEBUG W "MAP= ",MAP,!
   . N MED M MED=MEDS(RXIEN) ; PULL OUT MEDICATION FROM
   . S @MAP@("MEDOBJECTID")="MED"_MED(.01) ;Rx Number
   . S @MAP@("MEDISSUEDATETXT")
   . S @MAP@("MEDISSUEDATE")
   . S @MAP@("MEDLASTFILLDATETXT")
   . S @MAP@("MEDLASTFILLDATE")
   . S @MAP@("MEDRXNOTXT")
   . S @MAP@("MEDRXNO")
   . S @MAP@("MEDTYPETEXT")
   . S @MAP@("MEDDETAILUNADORNED")
   . S @MAP@("MEDSTATUSTEXT")
   . S @MAP@("MEDSOURCEACTORID")
   . S @MAP@("MEDPRODUCTNAMETEXT")
   . S @MAP@("MEDPRODUCTNAMECODEVALUE")
   . S @MAP@("MEDPRODUCTNAMECODINGINGSYSTEM")
   . S @MAP@("MEDPRODUCTNAMECODEVERSION")
   . S @MAP@("MEDBRANDNAMETEXT")
   . S @MAP@("MEDSTRENGTHVALUE")
   . S @MAP@("MEDSTRENGTHUNIT")
   . S @MAP@("MEDFORMTEXT")
   . S @MAP@("MEDCONCVALUE")
   . S @MAP@("MEDCONCUNIT")
   . S @MAP@("MEDSIZETEXT")
   . S @MAP@("MEDQUANTITYVALUE")
   . S @MAP@("MEDQUANTITYUNIT")
   . S @MAP@("MEDDIRECTIONDESCRIPTIONTEXT")
   . S @MAP@("MEDDOSEINDICATOR")
   . S @MAP@("MEDDELIVERYMETHOD")
   . S @MAP@("MEDDOSEVALUE")
   . S @MAP@("MEDDOSEUNIT")
   . S @MAP@("MEDRATEVALUE")
   . S @MAP@("MEDRATEUNIT")
   . S @MAP@("MEDVEHICLETEXT")
   . S @MAP@("MEDDIRECTIONROUTETEXT")
   . S @MAP@("MEDFREQUENCYVALUE")
   . S @MAP@("MEDFREQUENCYUNIT")
   . S @MAP@("MEDINTERVALVALUE")
   . S @MAP@("MEDINTERVALUNIT")
   . S @MAP@("MEDDURATIONVALUE")
   . S @MAP@("MEDDURATIONUNIT")
   . S @MAP@("MEDPRNFLAG")
   . S @MAP@("MEDPROBLEMOBJECTID")
   . S @MAP@("MEDPROBLEMDESCRIPTION")
   . S @MAP@("MEDPROBLEMCODEVALUE")
   . S @MAP@("MEDPROBLEMCODINGSYSTEM")
   . S @MAP@("MEDPROBLEMCODINGVERSION")
   . S @MAP@("MEDPROBLEMSOURCEACTORID")
   . S @MAP@("MEDSTOPINDICATOR")
   . S @MAP@("MEDDIRSEQ")
   . S @MAP@("MEDMULDIRMOD")
   . S @MAP@("MEDPTINSTRUCTIONS")
   . S @MAP@("MEDFULLFILLMENTINSTRUCTIONS")
   . S @MAP@("MEDRFNO")
   . N RESULT S RESULT=$NA(^TMP("GPLCCR",$J,"RESULT",J))
   . K @RESULT
   . D MAP^GPLXPATH(INXML,MAP,RESULT)
   . D:J=1 CP^GPLXPATH(RESULT,OUTXML) ; First one is a copy
   . D:J>1 INSINNER^GPLXPATH(OUTXML,RESULT) ; AFTER THE FIRST, INSERT INNER XML
   N MEDTMP,MEDI
   D MISSING^GPLXPATH(OUTXML,"MEDTMP") ; SEARCH XML FOR MISSING VARS
   I MEDTMP(0)>0 D  ; IF THERE ARE MISSING VARS - MARKED AS @@X@@
   . W "MEDICATION MISSING ",!
   . F MEDI=1:1:MEDTMP(0) W MEDTMP(MEDI),!
   Q
   ;
