#!perl -w
#this program converts a csv file of patient data to wikitext format
#
#this software is copyright George Lilly 2010 and is available as GPL
#its home is https://trac.opensourcevista.net/browser/hData/trunk/test-patients
#
#purpose: convert csv file to wikitext
#Second part of a chain of conversions which will create
#hData versions of the test patients. Also generate wiki-formatted versions
#to put on VistAPedia. 
#
my($intbl) = "none";
sub endtbl {
    print "\|\}\n";
}
sub dotr {
    print "\|----\n";
}
sub doetr {
    print "\|----\n";
}
sub spancol {
    my $tit = shift ; 
    my $cols = shift;
    print "\{\| border=\"1\"\|\n";
    print "\!colspan=\"$cols\"\|$tit\n";
}
sub docol {
    my $tit = shift ;
    print "\!scope\=\"col\"\|$tit\n";
}
sub dorow {
    my $tit = shift ;
    print "\|$tit\n";
}


while(<STDIN>)
{
    my($line) = $_;
    chomp($line);
    $line =~ s/ $//g;
    if (($line =~ m/^Patient/)&&($line !~ m/Summary/)) {
	if ($intbl !~ "none") { endtbl; }
	spancol("Patient",6);
#	print "$line\n";
	$intbl = "Patient";
    }
    elsif (($intbl =~ "Patient")&&($line =~ m/^Name/)) {
	dotr;
	$_ = $line;
	push @cols, split(/\|/);
	docol($_) for @cols ;
	doetr;
	@cols  = ();
    }
    elsif ($line =~ m/^Problem List/) {
	if ($intbl !~ "none") { endtbl; }
	spancol("Problem List",6);
#	print "$line\n";
	$intbl = "Problem List";
    }
    elsif (($intbl =~ "Problem List")&&($line =~ m/^Type/)) {
	dotr;
	$_ = $line;
	push @cols, split(/\|/);
	docol($_) for @cols ;
	doetr;
	@cols  = ();
    }
    elsif ($line =~ m/^Medication List/) {
	if ($intbl !~ "none") { endtbl; }
	spancol("Medication List",10);
#	print "$line\n";
	$intbl = "Medication List";
    }
    elsif (($intbl =~ "Medication List")&&($line =~ m/^RxNorm/)) {
	dotr;
	$_ = $line;
	push @cols, split(/\|/);
	docol($_) for @cols ;
	doetr;
	@cols  = ();
    }
    elsif ($line =~ m/^Medication Allergy List/) {
	if ($intbl !~ "none") { endtbl; }
	spancol("Medication Allergy List",5);
#	print "$line\n";
	$intbl = "Medication Allergy List";
    }
    elsif (($intbl =~ "Medication Allergy List")&&($line =~ m/^Type/)) {
	dotr;
	$_ = $line;
	push @cols, split(/\|/);
	docol($_) for @cols ;
	doetr;
	@cols  = ();
    }
    elsif ($line =~ m/^Diagnostic Test Results/) {
	if ($intbl !~ "none") { endtbl; }
	spancol("Diagnostic Test Results",5);
#	print "$line\n";
	$intbl = "Diagnostic Test Results";
    }
    elsif (($intbl =~ "Diagnostic Test Results")&&($line =~ m/^Type/)) {
	dotr;
	$_ = $line;
	push @cols, split(/\|/);
	docol($_) for @cols ;
	doetr;
	@cols  = ();
    }
    elsif ($line =~ m/^Procedure List/) {
	if ($intbl !~ "none") { endtbl; }
	spancol("Procedure List",5);
#	print "$line\n";
	$intbl = "Procedure List";
    }
    elsif (($intbl =~ "Procedure List")&&($line =~ m/^Type/)) {
	dotr;
	$_ = $line;
	push @cols, split(/\|/);
	docol($_) for @cols ;
	doetr;
	@cols  = ();
    }
    elsif (($intbl !~ "none")&&($line =~ m/\|/)) {
	$_ = $line;
	push @rows, split(/\|/);
	dorow($_) for @rows ;
	doetr;
	@rows = ();
    }	
    else {
	if ($intbl !~ "none") { endtbl; }
	print "$line\n";
	$intbl = "none";
    }
}
