/* SaveConfigColorsDelegate.as */

package gov.va.med.edp.business.config
{
	import gov.va.med.edp.business.ResponderChainingDelegate;
	
	import mx.rpc.IResponder;
    
	public class SaveConfigColorsDelegate extends ResponderChainingDelegate
	{	
		public function SaveConfigColorsDelegate(responder:IResponder)
		{
			super(responder, "saveColorConfig");
		}
	   	 
		public function saveConfigColors(area: int, colorXML: XML, colorToken: String): void
		{
			var params:Object = new Object();
			var i: int = 0;
			params.area = area;
			params.colorToken = colorToken;
			for each (var elem: XML in colorXML.children()) {
				if (elem.@type == "bed") continue;     // bed colors saved from room/bed screen
				if (elem.@type == "staff") continue;   // staff colors saved from staff screen
				i++;
				params["xml-"+i] = '<colors id="' + elem.@id + '" type="' + elem.@type + '" >';
				for each (var match: XML in elem.children()) {
					i++;
					params["xml-"+i] = match.toXMLString();
				}
				i++;
				params["xml-"+i] = '</colors>';
			}

			send(params);
		}
	}
}