/* SortHeaderCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.control.SortHeaderEvent;

	public class SortHeaderCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		public function execute(event:CairngormEvent):void
		{
			var sortEvent: SortHeaderEvent = SortHeaderEvent(event);
			if (sortEvent.type == SortHeaderEvent.EVENT_SORT_LOG_SELECTOR) {
				model.logEntryList.sortField = sortEvent.sortField;
				model.logEntryList.sortDescending = sortEvent.sortDescending;				
			}
			if (sortEvent.type == SortHeaderEvent.EVENT_SORT_DISPLAY_BOARD) {
				model.boardSortField = sortEvent.sortField;
				model.boardSortDescending = sortEvent.sortDescending;
			}

		}
	}
}