/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	
	import mx.rpc.events.ResultEvent;

	public class LoadActivityReportCommand extends BaseReportCommand
	{
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add log enteries to model
			model.reports.activityReport.activityLogs = ReportFactory.buildReportLogEntriesFromXML(xml.logEntries.log);
			//add averages to model..
			model.reports.activityReport.activityAverages = ReportFactory.buildReportAveragesFromXML(xml.averages.average);
									
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_ACTIVITY_REPORT;
		}
		
	}
}