/* TrackingModelLocator.as */

package gov.va.med.edp.model
{
import com.adobe.cairngorm.model.ModelLocator;

import flash.events.TimerEvent;
import flash.net.URLRequest;
import flash.net.navigateToURL;
import flash.utils.Timer;

import gov.va.med.edp.model.reports.ReportsModel;
import gov.va.med.edp.pt.demog.model.PatientChecksModel;
import gov.va.med.edp.vo.LogEditParamsVO;
import gov.va.med.edp.vo.LogSelectorVO;
import gov.va.med.edp.vo.SessionVO;
import gov.va.med.edp.vo.VisitVO;

import mx.collections.ArrayCollection;
import mx.collections.XMLListCollection;
import mx.rpc.Fault;


[Bindable]
public class TrackingModelLocator implements ModelLocator
{
	// Possible view states for the application
	public static const VIEW_APP_INTRO: int = 0;
	public static const VIEW_APP_SIGN_IN: int = 1;
	public static const VIEW_APP_TRIAGE: int = 2;
	public static const VIEW_APP_UPDATE: int = 3;
	public static const VIEW_APP_DISPOSITION: int = 4;
	public static const VIEW_APP_EDIT_CLOSED: int = 5;
	public static const VIEW_APP_DISPLAY_BOARD: int = 6;
	public static const VIEW_APP_ASSIGN_STAFF: int = 7;
	public static const VIEW_APP_REPORTS: int = 8;
	public static const VIEW_APP_CONFIGURE: int = 9;
	public static const VIEW_APP_VERSION_INCOMPATIBILITY: int = 90;
	public static const VIEW_APP_NO_VIEWS: int = 99;

	public static const VIEW_EDIT_MESSAGE: String = "Message";
	public static const VIEW_EDIT_SIGN_IN: String = "SignIn";
	public static const VIEW_EDIT_TRIAGE: String = "Triage";
	public static const VIEW_EDIT_UPDATE: String = "Update";
	public static const VIEW_EDIT_UPDATE_NORES: String = "UpdateNoRes";
	public static const VIEW_EDIT_DISP_DELAY: String = "DispDelay";
	public static const VIEW_EDIT_DISP_DELAY_CODED: String = "DispDelayCoded";
	public static const VIEW_EDIT_CLOSED: String = "EditClosed";
	public static const VIEW_EDIT_CLOSED_CODED: String = "EditClosedCoded";

	public static const APP_NAME_BIGBOARD: String = "bigboard";
	public static const APP_NAME_TRACKING: String = "tracking";
	
	public var bigboardInfo: BigBoardDebugInfo;

	public var appName: String = "";
	public var appClientVersion: String = "1.0";
	public var contextRoot: String = "";
	public var appViewList: ArrayCollection;
	public var appViewState: int = VIEW_APP_INTRO;
	public var logEntryViewState: String = "";
	public var logEntryTitle: String = "";

	// Session information
	public var session: SessionVO;
	public var rootURL: String;
	public var logoutURL: String;
	public var helpContextRootURL: String;

	// Reports
	public var reports: ReportsModel = new ReportsModel();

	// Debug
	public var debug: DebugModel = new DebugModel();

	// Log Editor
	public var logArea: int;
	public var logEntryList: LogEntryList = new LogEntryList();
	public var logEdit: LogEdit = new LogEdit();
	public var logEditParams: LogEditParamsVO;
	public var matchingDiagnoses: ArrayCollection;
	public var matchingDiagnosesLoaded: Boolean = false;

	// Patient Selection
	public var patientChecksModel:PatientChecksModel = new PatientChecksModel();

	public var matchingClosedVisits: ArrayCollection;
	public var matchingClosedVisitsIndex: int = -1;

	// Display Board
	public var boardSortField: String = "";
	public var boardSortDescending: Boolean;
	public var boardReady: Boolean = false;
	public var boardData: XMLListCollection;
	public var boardSpec: BoardSpec = new BoardSpec();
	public var boardLastUpdated: Date;

	// Configure
	public var config: Config = new Config();

	// Connectivity
	public var reconnectFunction:Function;
	public var disconnectionFault:Fault = null;
	private var _disconnected: Boolean = false;
	private var _connecting: Boolean = false;
	private var _reconnectTimer: Timer;

	public var reloadFunction:Function; // function for reloading the flash application in case of fatal error or sommat

	private static const RECONNECT_SECONDS:int = 10;

	//Singleton logic -----------------------------------------------------------

	private static var modelLocator: TrackingModelLocator;

	public static function getInstance(): TrackingModelLocator
	{
		if (modelLocator == null) {
			modelLocator = new TrackingModelLocator();
		}
		return modelLocator;
	}

	public function TrackingModelLocator()
	{
		if (modelLocator != null) {
			throw new Error("Only one TrackingModelLocator should be instantiated.");
		}
	}

	public function isDisconnected(): Boolean {
		return disconnected;
	}

	public function buildSiteDate(): Date
	{
		var now:Date = new Date();
		return new Date(now.time - session.baseTime.time + session.siteTime.time);
	}

	public function synchToLastEntry(): void
	{
		for (var i:int = 0; i < logEntryList.entries.length; i++) {
			var logSelector: LogSelectorVO = logEntryList.entries[i];
			if (logSelector.id == logEdit.entry.id) {
				logEntryList.selectedIndex = -1;  // force binding to fire
				logEntryList.selectedIndex = i;
				logEntryList.selectedID = logSelector.id;
				return;
			} // if
		} // for
	} // synchToLastEntry

	public function synchToClosedEntry(): void
	{
		for (var i: int = 0; i < matchingClosedVisits.length; i++) {
			var visit: VisitVO = matchingClosedVisits[i];
			if (visit.id == logEdit.entry.id) {
				matchingClosedVisitsIndex = -1;  // force binding to fire
				matchingClosedVisitsIndex = i;
				return;
			} // if
		} // for
	} // synchToClosedEntry

	public function appViewTitle(view: int): String
	{
		switch (appViewState) {
			case VIEW_APP_SIGN_IN:
				return "EDIS Sign In";
			case VIEW_APP_TRIAGE:
				return "EDIS Triage";
			case VIEW_APP_UPDATE:
				return "EDIS Update";
			case VIEW_APP_DISPOSITION:
				return "EDIS Disposition";
			case VIEW_APP_EDIT_CLOSED:
				return "EDIS Edit Closed Visit";
			case VIEW_APP_DISPLAY_BOARD:
				return "EDIS Display Board";
			case VIEW_APP_ASSIGN_STAFF:
				return "EDIS Staff List";
			case VIEW_APP_REPORTS:
				return "EDIS Reports";
			case VIEW_APP_CONFIGURE:
				return "EDIS Configuration";
			case VIEW_APP_NO_VIEWS:
				return "EDIS";
			default:
				return "EDIS";
		}
	}

	public function appViewHelp(view: int): String
	{
		switch (appViewState) {
			case VIEW_APP_SIGN_IN:
				return "SignIn";
			case VIEW_APP_TRIAGE:
				return "Triage";
			case VIEW_APP_UPDATE:
				return "Update";
			case VIEW_APP_DISPOSITION:
				return "Disposition";
			case VIEW_APP_EDIT_CLOSED:
				return "EditClosedVisit";
			case VIEW_APP_DISPLAY_BOARD:
				return "DisplayBoard";
			case VIEW_APP_ASSIGN_STAFF:
				return "StaffList";
			case VIEW_APP_REPORTS:
				return "Reports";
			case VIEW_APP_CONFIGURE:
				return "Configuration";
			case VIEW_APP_NO_VIEWS:
				return "General";
			default:
				return "General";
		}
	}

	public function setEditState(): void
	{
		// always start at the beginning
		logEntryViewState = "";

		if (logEdit.entry == null) {
			logEntryViewState = VIEW_EDIT_MESSAGE;
			return;
		}

		// convenient place to clear lookup list since this is called when entry changes
		matchingDiagnoses = null;

		switch (appViewState) {
			case VIEW_APP_SIGN_IN:
				logEntryViewState = VIEW_EDIT_SIGN_IN;
				break;
			case VIEW_APP_TRIAGE:
				logEntryViewState = VIEW_EDIT_TRIAGE;
				break;
			case VIEW_APP_UPDATE:
				logEditParams.promptResidents ?
				logEntryViewState = VIEW_EDIT_UPDATE : logEntryViewState = VIEW_EDIT_UPDATE_NORES;
				break;
			case VIEW_APP_DISPOSITION:
				logEditParams.codedDiagnosis ?
				logEntryViewState = VIEW_EDIT_DISP_DELAY_CODED :
				logEntryViewState = VIEW_EDIT_DISP_DELAY;
				break;
			case VIEW_APP_EDIT_CLOSED:
				logEditParams.codedDiagnosis ?
				logEntryViewState = VIEW_EDIT_CLOSED_CODED :
				logEntryViewState = VIEW_EDIT_CLOSED;
				break;
			default:
				logEntryViewState = VIEW_EDIT_MESSAGE;
				break;
		} // switch
	} // setEditState

	public function modifiedViews(): String
	{
		var x: String = "";
		if (logEdit.dirty) {
			var viewName: String = logEntryViewState;
			viewName = (viewName.substr(0, 4) == "Disp") ? "Disposition" : viewName;
			viewName = (viewName.substr(0, 4) == "Upda") ? "Update" : viewName;
			viewName = (viewName.substr(0, 4) == "Edit") ? "Edit Closed" : viewName;
			x += "\t" + viewName + "\n";
		}
		x += config.staffMods ? "\tStaff Configuration \n" : "";
		x += config.bedMods ? "\tRoom / Area Configuration \n" : "";
		x += config.boardMods ? "\tDisplay Board Configuration \n" : "";
		x += config.colorMods ? "\tColor Configuration \n" : "";
		x += config.paramMods ? "\tParameter Configuration \n" : "";
		x += config.selectionMods ? "\tSelection List Configuration \n" : "";
		return x;
	}

	public function entryRemoveReady(): void
	{
		var ready: Boolean = true;

		// special dispositions that allow immediate removal
		if ((logEdit.entry.disposition == logEditParams.errorIEN) ||
			(logEdit.entry.disposition == logEditParams.nurseEvalIEN) ||
			(logEdit.entry.disposition == logEditParams.leftIEN)) {
			logEdit.entry.removeReady = true;
			return;
		}

		if (logEdit.entry.requireDiagnosis && (logEdit.entry.diagnoses.length == 0)) {
			ready = false;
		}
		if (logEdit.entry.requireDisposition &&
			((logEdit.entry.disposition == logEditParams.emptyValue) ||
			 (logEdit.entry.disposition < 1))) {
			ready = false;
		}
		if (logEdit.entry.requireDelay &&
			((logEdit.entry.delay == logEditParams.emptyValue) ||
			 (logEdit.entry.delay < 1))) {
			ready = false;
		}
		if (Number(logEdit.entry.provider) < 1) {
			ready = false;
		}

		logEdit.entry.removeReady = ready;
	}

	public function logout(): void {
		var request: URLRequest = new URLRequest(logoutURL);
		navigateToURL(request, "_top");
	}

	public function get disconnected(): Boolean {
		return _disconnected;
	}

	public function set disconnected(b:Boolean):void {
		if (_disconnected && !b) {
			stopReconnectCountdown();
			disconnectionFault = null;
		} else if (!_disconnected && b) {
			startReconnectCountdown();
		}
		_disconnected = b;
	}

	public function get connecting(): Boolean {
		return _connecting;
	}

	public function set connecting(b:Boolean):void {
		_connecting = b;
		if (disconnected) {
			if (!_connecting) {
				startReconnectCountdown();
			} else {
				stopReconnectCountdown();
			}
		}
	}

	[Bindable(event="reconnectSecondsChanged")]
	public function get reconnectSeconds():int {
		if (_reconnectTimer == null) return RECONNECT_SECONDS;
		return _reconnectTimer.repeatCount - _reconnectTimer.currentCount;
	}

	public function attemptReconnect():void {
		stopReconnectCountdown();
		reconnectFunction.call(null);
	}

	private function reconnectCountDown(e:TimerEvent):void {
		dispatchEvent(new Event("reconnectSecondsChanged"));
	}

	private function reconnectTimerComplete(e:TimerEvent):void {
		attemptReconnect();
	}

	private function startReconnectCountdown():void {
		if (_reconnectTimer == null) {
			_reconnectTimer = new Timer(1000, RECONNECT_SECONDS);
			_reconnectTimer.addEventListener(TimerEvent.TIMER, reconnectCountDown);
			_reconnectTimer.addEventListener(TimerEvent.TIMER_COMPLETE, reconnectTimerComplete);
		}
		_reconnectTimer.reset();
		_reconnectTimer.start();
	}

	private function stopReconnectCountdown():void {
		if (_reconnectTimer != null) {
			_reconnectTimer.reset();
		}
	}

} // class
} // package
