package gov.va.med.edp.util
{
	import gov.va.med.edp.control.reports.ReportDownloadEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.view.reports.print.ReportDataGridPrintView;
	import gov.va.med.edp.vo.reports.ReportParamsVO;
	
	import mx.containers.HBox;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.Application;
	import mx.printing.FlexPrintJob;
	import mx.utils.ObjectUtil;
	
	public class ReportUtil
	{
		private static var model: TrackingModelLocator = TrackingModelLocator.getInstance();
		public static const millisecondsPerHour:int = 1000 * 60 * 60;
		private static const DT_FORMAT: String = "DD MMM YY JJ:NN";
		private static const ACCESSIBLE_DT_FORMAT: String = "MMMM DD, YYYY JJ:NN";
					
		static public function buildReportLabelText(initilizationText:String): String
		{
			var startDate:String = Vista.formattedDate(model.reports.startDate, DT_FORMAT);
			var stopDate:String = Vista.formattedDate(model.reports.stopDate, DT_FORMAT);
			var lbltext:String = initilizationText + " from " + startDate + " to " + stopDate;
 			return lbltext;
		}
		
		static public function accessibleReportLabelText(initilizationText:String): String
		{
			var startDate:String = Vista.formattedDate(model.reports.startDate, ACCESSIBLE_DT_FORMAT);
			var stopDate:String = Vista.formattedDate(model.reports.stopDate, ACCESSIBLE_DT_FORMAT);
			var lbltext:String = initilizationText + " from " + startDate + " to " + stopDate;
 			
 			return lbltext;
		}
		
		static public function calculateEndTimeForShiftReport(startDate:Date): Date
		{
			var endDate:Date = new Date(startDate.getTime());
			endDate.setTime(endDate.getTime() + (24* millisecondsPerHour));
			return endDate;
		}
		
		static public function formatReportDate(item: Object, column: DataGridColumn): String
		{
			var dataField:String = column.dataField;
			if ((item != null) && (item[dataField] != null)) {
				return Vista.formattedDate(item[dataField], "M/D/YY JJ:NN");					
			} else {
				return "";
			}
		}
		
		static public function sortTimeInDates(obj1:Object, obj2:Object):int
		{
			var date1: Date = obj1.timeIn;
			var date2: Date = obj2.timeIn;
			return ObjectUtil.dateCompare(date1, date2);
		} 		
		
		static public function sortTimeOutDates(obj1:Object, obj2:Object):int
		{
			var date1: Date = obj1.timeOut;
			var date2: Date = obj2.timeOut;
			return ObjectUtil.dateCompare(date1, date2);
		} 				
		
		static public function exportReport(reportName:String, reportId:String=null): void
		{
			var reportEvent: ReportDownloadEvent = new ReportDownloadEvent(ReportDownloadEvent.EVENT_DOWNLOAD_REPORT);
			var reportParams: ReportParamsVO = new ReportParamsVO();
			reportParams.reportName = reportName;
			reportParams.startDate = new Date(model.reports.startDate);	
			reportParams.stopDate = new Date(model.reports.stopDate);
			reportParams.id = reportId;
			reportEvent.reportParams = reportParams;
			reportEvent.dispatch();
		}		
		
		static public function setExportButtonState(button:HBox): void
		{
			button.visible = model.session.canExport;
		}		
		
		static public function printDataGrid(printJob:FlexPrintJob, gridColumns:Array, dataProviderForGrid:Object, reportHeaderText: String, gridFontSize:int=8, reportHeaderFontSize:int=8):void{
	                // Create a FormPrintView control as a child of the current view.
            var dataGridPrintView:ReportDataGridPrintView = new ReportDataGridPrintView();
           Application.application.addChild(dataGridPrintView);

            //Set the print view properties.
            //FlexPrintJobScaleType
            dataGridPrintView.width=printJob.pageWidth;
            dataGridPrintView.height=printJob.pageHeight;
            dataGridPrintView.lblHeaderText = reportHeaderText;
            // Set the data provider of the FormPrintView component's data grid
            // to be the data provider of the displayed data grid.
            dataGridPrintView.reportDataGrid.columns = gridColumns;
            dataGridPrintView.reportDataGrid.dataProvider = dataProviderForGrid;
            dataGridPrintView.reportDataGrid.setStyle('fontSize', gridFontSize);
            dataGridPrintView.header.setStyle('fontSize', reportHeaderFontSize);
            // Create a single-page image.
            dataGridPrintView.showPage("single");
            // If the print image's data grid can hold all the provider's rows,
            // add the page to the print job.
            if(!dataGridPrintView.reportDataGrid.validNextPage)
            {
                printJob.addObject(dataGridPrintView);
            }
            // Otherwise, the job requires multiple pages.
            else
            {
                // Create the first page and add it to the print job.
                dataGridPrintView.showPage("first");
                printJob.addObject(dataGridPrintView);
                dataGridPrintView.pageNumber++;
                // Loop through the following code until all pages are queued.
                while(true)
                {
                    // Move the next page of data to the top of the print grid.
                    dataGridPrintView.reportDataGrid.nextPage();
                    dataGridPrintView.showPage("last");
                    // If the page holds the remaining data, or if the last page
                    // was completely filled by the last grid data, queue it for printing.
                    // Test if there is data for another PrintDataGrid page.
                    if(!dataGridPrintView.reportDataGrid.validNextPage)
                    {
                        // This is the last page; queue it and exit the print loop.
                        printJob.addObject(dataGridPrintView);
                        break;
                    }
                    else
                    // This is not the last page. Queue a middle page.
                    {
                        dataGridPrintView.showPage("middle");
                        printJob.addObject(dataGridPrintView);
                        dataGridPrintView.pageNumber++;
                    }
                }
            }
            // All pages are queued; remove the FormPrintView control to free memory.
            Application.application.removeChild(dataGridPrintView);
		}
				
	}
}