/* LogEntryVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import gov.va.med.edp.util.Vista;
	
	import mx.collections.ArrayCollection;

	[Bindable]
	public class LogEntryVO implements IValueObject
	{
		public var id: Number;
		public var site: int;
		public var area: int;
		
		public var dfn: String;
		public var name: String;
		public var ssn: String;
		public var dob: String;
		public var arrival: int;
		public var inTS: Date;
		public var visit: int;
		public var clinic: int;
		public var closed: Boolean;
		public var complaint: String;
		public var longComplaint: String;
		public var status: int;
		public var acuity: int;
		public var bed: int;
		public var provider: String;
		public var resident: String;
		public var nurse: String;
		public var comment: String;
		public var outTS: Date;
		public var delay: int;
		public var disposition: int;
		public var diagnoses: ArrayCollection = new ArrayCollection();
		public var required: String;
		public var isStub: Boolean = false;
		public var removeReady: Boolean = false;
		public var requireDelay: Boolean = false;
		public var requireDisposition: Boolean = false;
		public var requireDiagnosis: Boolean = false;
		public var updatedDiagnoses: Boolean = false;
		public var patientFlags: ArrayCollection;
		public var loadTS: String;  // Fileman time for when record loaded, no need to made Date
		
		public function toString():String
		{
			var x: String =
				"id=" + id + "\t" +
				"site=" + site + "\t" +
				"area=" + area + "\t" +
				"dfn=" + dfn + "\t" +
				"name=" + name + "\t" +
				"ssn=" + ssn + "\t" +
				"dob=" + dob + "\t" +
				"arrival=" + arrival + "\t" +
				"clinic=" + clinic + "\t" +
				"inTS=" + Vista.DatetoFM(inTS) + "\t" +
				"complaint=" + complaint + "\t" +
				"compLong=" + longComplaint + "\t" +
				"status=" + status + "\t" +
				"acuity=" + acuity + "\t" +
				"bed=" + bed + "\t" +
				"provider=" + provider + "\t" +
				"resident=" + resident + "\t" +
				"nurse=" + nurse + "\t" +
				"comment=" + comment + "\t" +
				"outTS=" + Vista.DatetoFM(outTS) + "\t" +
				"delay=" + delay + "\t" +
				"disposition=" + disposition + "\t" +
				"required=" + required + "\t" +
				"updDiag=" + (updatedDiagnoses ? "1" : "0") + "\t" +
				"loadTS=" + loadTS + "\t";
				
				var seq: int = 0;
				for each (var codedValue: PCECodedValueVO in diagnoses.source) {
					seq++;
					x = x + "diagnosis-" + seq + "=" +
						codedValue.type + "^" +
						codedValue.ien.toString() + "^" +
						codedValue.code + "^" +
						codedValue.label + "^" +
						(codedValue.added ? "1" : "") + "^" +
						(codedValue.remove ? "1" : "") + "^" +
						(codedValue.updated ? "1" : "") + "^" +
						(codedValue.primary ? "1" : "") + "^" +
						codedValue.quantity + "\t";
				}
				return x;
		}
		
		public function copyTo(dest: LogEntryVO): void
		{
			dest.id = this.id;
			dest.site = this.site;
			dest.area = this.area;
			dest.dfn = this.dfn;
			dest.name = this.name;
			dest.ssn = this.ssn;
			dest.dob = this.dob;
			dest.arrival = this.arrival;
			dest.inTS = this.inTS;
			dest.visit = this.visit;
			dest.clinic = this.clinic;
			dest.closed = this.closed;			
			dest.complaint = this.complaint;
			dest.longComplaint = this.longComplaint;
			dest.status = this.status;
			dest.acuity = this.acuity;
			dest.bed = this.bed;
			dest.provider = this.provider;
			dest.resident = this.resident;
			dest.nurse = this.nurse;
			dest.comment = this.comment;
			dest.outTS = this.outTS;
			dest.delay = this.delay;
			dest.disposition = this.disposition;			
			dest.diagnoses = this.diagnoses;
			dest.required = this.required;
			dest.isStub = this.isStub;
			dest.removeReady = this.removeReady;
			dest.requireDelay = this.requireDelay;
			dest.requireDiagnosis = this.requireDiagnosis;
			dest.updatedDiagnoses = this.updatedDiagnoses;
			dest.requireDisposition = this.requireDisposition;
			dest.patientFlags = this.patientFlags;
			dest.loadTS = this.loadTS;
		}
		
		public function clear(): void
		{
			id = 0;
			site = 0;
			area = 0;
			
			dfn = "";
			name = "";
			ssn = "";
			dob = "";
			arrival = 0;
			inTS = new Date;
			visit = 0;
			clinic = 0;
			closed = false;
			complaint = "";
			longComplaint = "";
			status = 0;
			acuity = 0;
			bed = 0;
			provider = "";
			resident = "";
			nurse = "";
			comment = "";
			outTS = new Date;
			delay = 0;
			disposition = 0;
			diagnoses = new ArrayCollection();
			required = "";
			isStub = false;
			removeReady = false;
			requireDelay = false;
			requireDiagnosis = false;
			updatedDiagnoses = false;
			requireDisposition = false;
			patientFlags = null;
			loadTS = "";
		}
	}
}