package gov.va.med.edp.web.view;

import org.springframework.web.servlet.view.AbstractView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

public class CsvView extends AbstractView {

    public static final String CSV_MODEL = "csvModel";   
    private static final String CONTENT_TYPE = "application/vnd.ms-excel";
    
    public CsvView() {
       setContentType(CONTENT_TYPE);
    }

    protected void renderMergedOutputModel(Map map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpCacheControl.addNoCacheHeaders(response);
        response.getWriter().print(map.get(CSV_MODEL));
        response.getWriter().close();
    }
}
