/* ChangeParamFieldCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.control.config.ChangeFieldEvent;
	import gov.va.med.edp.model.TrackingModelLocator;

	public class ChangeParamFieldCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var e: ChangeFieldEvent = ChangeFieldEvent(event);
			model.config.paramMods = true;

			switch(e.field)
			{
				case "reqDiag":
					model.config.params.requireDiagnosis = e.value;
					break;
				case "codedDiag":
					model.config.params.codedDiagnosis = e.value;
					break;
				case "reqDisp":
					model.config.params.requireDisposition = e.value;
					break;
				case "reqDelay":
					model.config.params.requireDelay = e.value;
					break;
				case "minDelay":
					model.config.params.delayMinutes = e.value;
					break;
				case "shiftOne":
					model.config.params.shiftStart = e.value;
					break;
				case "shiftLen":
					model.config.params.shiftDuration = e.value;
					break;
				case "residents":
					model.config.params.promptResidents = e.value;
					break;
				case "clinics":
					model.config.params.promptClinics = e.value;
					break;
				case "ambulance":
					model.config.params.ambulanceArea = e.value;
					break;
				case "dfltRoom":
					model.config.params.defaultRoom = e.value;
					break;
			}
		}
	}
}