/* SaveConfigStaffCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.SaveConfigStaffDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.vo.StaffMemberVO;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class SaveConfigStaffCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var updatedStaff: ArrayCollection = new ArrayCollection();
			var staff: StaffMemberVO;
			
			for each (staff in model.config.providers.source) {
				if (staff.changed || staff.colorChanged) { updatedStaff.addItem(staff); }
			}
			for each (staff in model.config.residents.source) {
				if (staff.changed || staff.colorChanged) { updatedStaff.addItem(staff); }
			}
			for each (staff in model.config.nurses.source) {
				if (staff.changed || staff.colorChanged) { updatedStaff.addItem(staff); }
			}

			model.config.staffConfigLoaded = false;
			var delegate: SaveConfigStaffDelegate = new SaveConfigStaffDelegate(this);
			delegate.saveConfigStaff(model.logArea, model.config.staffToken, updatedStaff);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			if  ((xml.save.@status == "ok") || (xml.save.@status == "collide")) {
				BoardTools.applyStaffLists(model.config, xml);
				model.config.staffConfigLoaded = true;

				if (xml.save.@status == "ok") {
					InfoDialog.show("New staff configuration saved.");
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}
			}
			
			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for staff: " + super.getFaultMessage(faultEvent);
		}
	}
}