/* SessionFactory.as */

package gov.va.med.edp.factory
{
    import gov.va.med.edp.util.Vista;
    import gov.va.med.edp.vo.LookupStringVO;
    import gov.va.med.edp.vo.LookupVO;
    import gov.va.med.edp.vo.SessionVO;
    
    import mx.collections.ArrayCollection;
        
    public class SessionFactory
    {
        /*
        expects XML node:
        <anyRoot>
            <user duz="99" site="99" siteNm="a name" area="99" areaName="a name" />
        </anyRoot>
        */
        public static function buildSessionFromXML(xml:XML):SessionVO
        {
        	//since this is the ONLY call that does not get added to the debug tool..tracing xml here for debug mode..
        	trace ("Session XML\n" + xml);
            var sessionVO:SessionVO = new SessionVO();
            sessionVO.duz = xml.user[0].@duz;
            sessionVO.site = xml.user[0].@station;
            sessionVO.siteName = xml.user[0].@siteNm;
            sessionVO.area = xml.user[0].@area;
            sessionVO.areaName = xml.user[0].@areaNm;
            sessionVO.baseTime = new Date();
            sessionVO.siteTimeFM = xml.user[0].@time;
            sessionVO.siteTime = Vista.FMtoDate(sessionVO.siteTimeFM);

            var timeOut:int = xml.user[0].@timeOut;
            if (timeOut > 0) sessionVO.timeOut = timeOut;
            var countDown:int = xml.user[0].@countDown;
            if (countDown > 0) sessionVO.countDown = countDown;

            sessionVO.canExport = (xml.user[0].@rptExport == "1")
            sessionVO.showProviderReport = (xml.user[0].@rptProvider == "1");
            sessionVO.showPatientCrossReferenceReport = (xml.user[0].@rptXRef == "1");
            sessionVO.debugEnabled = (xml.user[0].@progMode == "1");

            sessionVO.serverPackageVersion = xml.user[0].@version;

            return sessionVO;
        }
        
        /*
        expects XML node:  <anyNode data="internalID" label="externalName" />
        */
        public static function buildLookupItemFromXML(xml:XML):LookupVO
        {
        	var lookupVO:LookupVO = new LookupVO();
        	lookupVO.data = Number(xml.@data);
        	lookupVO.label = xml.@label;
        	lookupVO.abbr = xml.@abbr;
        	return lookupVO;
        }
        
        /*
        expects xml to be: 
        <anyRoot>
	      	<anyNode data="internalID" label="externalName" />
    	   	<anyNode data="internalID" label="externalName" />
    	   	...
    	</anyRoot>
    	*/

        public static function buildLookupListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var lookupList:ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var lookupVO:LookupVO = buildLookupItemFromXML(item);
        		lookupList.addItem(lookupVO);
        	}
        	return lookupList;
        }
        
        public static function buildLookupStringListFromXML(nodeList: XMLList): ArrayCollection
        {
        	var list: ArrayCollection = new ArrayCollection();
        	for each (var item: XML in nodeList) {
        		var lookupStringVO: LookupStringVO = new LookupStringVO();
        		lookupStringVO.data = item.@data;
        		lookupStringVO.label = item.@label;
        		lookupStringVO.reference = item.@ref;
        		list.addItem(lookupStringVO);
        	}
        	return list;
        }
    }
}