/* Config.as */

package gov.va.med.edp.model
{
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.DisplayBoardPropertiesVO;
	import gov.va.med.edp.vo.LogEditParamsVO;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	public class Config
	{
		// configure display board & colors
		public var boards: ArrayCollection;				 // array of LookupVO
		public var boardIndex: int = 0;

		public var columns: ArrayCollection;             // array of ColumnSpecVO		
		public var availableColumns: ArrayCollection;    // array of ColumnSpecVO

		public var colorMaps: ArrayCollection;	         // array of ColorMap
		public var rowColorMap: ColorMapVO;
		public var rowColorMapIndex: int = -1;

		public var displaySizes: ArrayCollection;
		public var displayBoardProperties: DisplayBoardPropertiesVO;

		// configure rooms/beds
		public var beds: ArrayCollection;		         // array of RoomBedVO
		public var statusList: ArrayCollection;          // array of LookupVO
		public var whenList: ArrayCollection;			 // array of LookupVO
		public var roomCategoryList: ArrayCollection;	 // array of LookupVO
		
		// configure staff
		//public var srcProviders: ArrayCollection;		 // arrays of StaffMemberVO
		//public var srcNurses:  ArrayCollection;
		public var srcStaff: ArrayCollection;
		public var srcStaffReady: Boolean = false;
		
		public var providers: ArrayCollection;
		public var residents: ArrayCollection;
		public var nurses: ArrayCollection;
		
		// configure selections
		public var acuities: ArrayCollection;			// arrays of CodeSelectionVO
		public var statuses: ArrayCollection;
		public var arrivals: ArrayCollection;
		public var dispositions: ArrayCollection;
		public var delays: ArrayCollection;
		public var acuitiesChanged: Boolean = false;	// dirty flags for each list
		public var statusesChanged: Boolean = false;
		public var arrivalsChanged: Boolean = false;
		public var dispositionsChanged: Boolean = false;
		public var delaysChanged: Boolean = false;
		
		// configure params
		public var params: LogEditParamsVO = new LogEditParamsVO();
		public var defaultRoomList: ArrayCollection;   // array of LookupVO
		
		// loaded flags
		public var bedLoaded: Boolean = false;
		public var boardLoaded: Boolean = false;
		public var colorLoaded: Boolean = false;
		public var paramLoaded: Boolean = false;
		public var selectionConfigLoaded: Boolean = false;
		public var staffConfigLoaded: Boolean = false;

		// dirty flags
		public var bedMods: Boolean = false;
		public var boardMods: Boolean = false;
		public var colorMods: Boolean = false;
		public var paramMods: Boolean = false;
		public var selectionMods: Boolean = false;
		public var staffMods: Boolean = false;
		
		// locking tokens
		public var bedToken: String = "";
		public var boardToken: String = "";
		public var colorToken: String = "";
		public var paramToken: String = "";
		public var selectionToken: String = "";
		public var staffToken: String = "";
	}
}