/*  MatchPatientsCommand.as */

package gov.va.med.edp.pt.demog.control
{
import gov.va.med.edp.pt.demog.model.MatchingPatientsModel;
import gov.va.med.edp.pt.demog.dao.PatientXml;
import gov.va.med.edp.command.AbstractResponderCommand;

import mx.rpc.IResponder;
import mx.rpc.events.FaultEvent;
import mx.rpc.events.ResultEvent;

public class MatchPatientsResponder extends AbstractResponderCommand implements IResponder
{
    private var model:MatchingPatientsModel;

    public function MatchPatientsResponder(model:MatchingPatientsModel):void {
        this.model = model
    }

    public override function result(data:Object):void
    {
        var xml:XML = ResultEvent(data).result as XML;
        model.matchingPatients =
        PatientXml.buildLookupPatientListFromXML(xml);

        model.matchingPatientsTruncated = (xml.matchesTruncated == "true");
        trace("trucated: ", model.matchingPatientsTruncated);
        model.matchingPatientsLoaded = true;
    }

    protected override function getFaultMessage(faultEvent:FaultEvent):String {
        return "Retrieve matching patients failed: " + super.getFaultMessage(faultEvent);
    }
}
}