/* LogEditParamsVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	public class LogEditParamsVO implements IValueObject
	{
		public var requireDiagnosis: Boolean;
		public var codedDiagnosis: Boolean;
		public var requireDisposition: Boolean;
		public var requireDelay: Boolean;
		public var delayMinutes: int;
		public var shiftStart: int;
		public var shiftDuration: int;
		public var promptResidents: Boolean;
		public var promptClinics: Boolean;
		public var ambulanceArea: int;
		public var defaultRoom: int;
		public var emptyValue: int;		// used to hold code for empty value, not editable
		public var errorIEN: int;		// entered in error
		public var nurseEvalIEN: int;	// send to nurse eval clinic
		public var leftIEN: int;		// left without being seen
		
		public function toString():String
		{
			return "reqDiag=" + (requireDiagnosis ? "1" : "0") + "\t" +
				"codedDiag=" + (codedDiagnosis ? "1" : "0") + "\t" +
				"reqDisp=" + (requireDisposition ? "1" : "0") + "\t" +
				"reqDelay=" + (requireDelay ? "1" : "0") + "\t" +
				"minDelay=" + delayMinutes + "\t" +
				"shiftOne=" + shiftStart + "\t" +
				"shiftLen=" + shiftDuration + "\t" +
				"residents=" + (promptResidents ? "1" : "0") + "\t" +
				"clinics=" + (promptClinics ? "1" : "0") + "\t" +
				"ambulance=" + ambulanceArea + "\t" + 
				"dfltroom=" + defaultRoom + "\t";
		}
	}
}
