/* StaffMemberVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	public class StaffMemberVO implements IValueObject
	{
		public var duz: String;
		public var inactive: Boolean = false;
		public var name: String;
		public var initials: String;
		public var role: String;
		public var color: ColorSelectionVO;
		public var colorChanged: Boolean = false;
		public var changed: Boolean = false;
		public var displayName:String;

		public function toString(): String
		{
			// in the string form, the first comma piece is 1 if Code should be used
			
			var isChanged: Boolean = (changed || colorChanged);
			var x: String =
				"duz=" + duz + "\t" +
				"inact=" + (inactive ? "1" : "0") + "\t" +
				"nm=" + name + "\t" +
				"itl=" + initials + "\t" +
				"role=" + role + "\t" +
				"clr=" + color.toString() + "\t" +
				"chg=" + (isChanged ? "1" : "0") + "\t";
			return x;
		}
	}
}