package gov.va.med.edp.widget
{
	import flash.display.DisplayObject;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	import mx.controls.CheckBox;
	import mx.controls.dataGridClasses.DataGridListData;
	import mx.controls.listClasses.IListItemRenderer;

	public class CenteredCheckBox extends CheckBox implements IListItemRenderer
	{

		private var _data: Object;
		
        override public function set data(value:Object):void
        {
        	if(value != null) {
        		super.data = value;
        		_data = value;
        		var dataField: Object = DataGridListData(listData).dataField;
        		selected = value[dataField];
        	} else {
        		selected = false;
        	}
        }
        
		override public function get data(): Object
		{
			return _data;
		}        
		
        override protected function clickHandler(event:MouseEvent):void
        {
            super.clickHandler(event);
            data[DataGridListData(listData).dataField] = selected;
        }		
		
        // center the contentHolder
        override protected function updateDisplayList(w:Number, h:Number):void
        {
        	super.updateDisplayList(w, h);

            var n:int = numChildren;
            for (var i:int = 0; i < n; i++)
            {
            	var c:DisplayObject = getChildAt(i);
            	if (!(c is TextField)) {
                	c.x = (w - c.width) / 2;
                    c.y = 0;
                }
            }
        }		
	}
}
