package gov.va.med.edp.pt.demog.model {
import gov.va.med.edp.pt.demog.*;

import flexunit.framework.TestCase;
import mx.collections.ArrayCollection;

public class TestPatientCheckVO extends TestCase {

    public function testOnBoard():void {
        var c:PatientCheckVO = new PatientCheckVO();
        assertFalse(c.isOnBoard());
        c.onBoardText = "foo";
        assertTrue(c.isOnBoard());
    }

    public function testIsDeceased():void {
        var c:PatientCheckVO = new PatientCheckVO();
        assertFalse(c.isOnBoard());
        c.deceasedText = "foo";
        assertTrue(c.isDeceased());
    }

    public function testHasSimilarNames():void {
        var c:PatientCheckVO = new PatientCheckVO();
        assertFalse(c.hasSimilarNames());
        c.similarNames = [];
        assertFalse(c.hasSimilarNames());
        c.similarNames = createPtList();
        assertTrue(c.hasSimilarNames());
    }

    public function testHasFlags():void {
        var c:PatientCheckVO = new PatientCheckVO();
        assertFalse(c.hasFlags());
        c.flags = new ArrayCollection();
        assertFalse(c.hasFlags());
        c.flags = createPtFlags();
        assertTrue(c.hasFlags());
    }

    public static function createPtList():Array {
        var pt1:PatientSelectVO = new PatientSelectVO();
        pt1.dfn = "fefefef"

        var pt2:PatientSelectVO = new PatientSelectVO();
        pt2.dfn = "efeerfer";

        var pt3:PatientSelectVO = new PatientSelectVO();
        pt3.dfn = "fe34ef"

        return [pt1, pt2, pt3];
    }

    public static function createPtFlags():ArrayCollection {
        var flag1:PatientRecordFlagVO = new PatientRecordFlagVO();
        flag1.name = "foo";
        flag1.type = "bar";
        flag1.status = "baz";

        var flags:ArrayCollection = new ArrayCollection();
        flags.addItem(flag1);
        return flags;
    }
}
}