/* InitAppCommand.as */

package gov.va.med.edp.command
{
	import com.adobe.cairngorm.business.ServiceLocator;
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.InitUserDelegate;
	import gov.va.med.edp.business.Services;
	import gov.va.med.edp.control.InitAppEvent;
	import gov.va.med.edp.control.TrackingEvent;
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.view.ErrorDialog;
	import gov.va.med.edp.vo.SessionVO;

	import mx.core.Application;

    import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	
	public class InitAppCommand extends AbstractResponderCommand implements ICommand, IResponder
    {
        private    var model:TrackingModelLocator = TrackingModelLocator.getInstance();

        public function execute(event:CairngormEvent):void
        {
            // set up Services.mxml so it knows the runtime URL
            var e: InitAppEvent = InitAppEvent(event);
            var prefix: String = "";

            if (e.mode == InitAppEvent.SERVICE_USE_VLJ) {
                prefix = e.protocol + "://" + e.server + e.contextRoot + "/";
                model.rootURL = prefix;
                model.logoutURL = prefix + "logout.html?swfID=" + Application.application.parameters.swfID;
                model.helpContextRootURL = e.protocol + "://" + e.server + "/" + e.helpContextRoot + "/";
                if (e.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
                    if (!e.timeout) {
                        model.logoutURL = prefix + "reset.jsp";
                    }
                }
            }
            if (e.mode == InitAppEvent.SERVICE_USE_CSP) {
                prefix = e.protocol + "://" + e.server + "/";
                model.rootURL = prefix;
                model.logoutURL = prefix + "edp.logout.cls";
                model.helpContextRootURL = e.protocol + "://" + e.server + "/" + e.helpContextRoot + "/";
            }
            Services(ServiceLocator.getInstance()).callPrefix = prefix;
            Services(ServiceLocator.getInstance()).callMode = e.mode;
            model.appName = e.appName;
            model.contextRoot = e.contextRoot;

            if (e.appName == TrackingModelLocator.APP_NAME_BIGBOARD) {
                if (e.timeout) {
                    new InitUserDelegate(this).initUser(e.token);
                } else {
					initAnonymousUser(e.areaName);						
				}
            } else {
                new InitUserDelegate(this).initUser(e.token);
            }
        }

        // don't call facility server for big board
        private function initAnonymousUser(areaName: String): void
        {
            model.session = new SessionVO();
            model.session.duz = "0";
            model.session.site = "";
            model.session.siteName = "";
            model.session.area = 0;
            model.session.areaName = areaName;
            model.session.baseTime = new Date();
            model.session.timeOut = 3600000;
            model.session.countDown = 0;
            model.session.canExport = false;
            model.session.showProviderReport = false;
            model.session.showPatientCrossReferenceReport = false;
            model.session.debugEnabled = false;
            // model.appViewList not used by big board (no menu on left side)
            new TrackingEvent(TrackingEvent.EVENT_INIT_TRACKING).dispatch();

        }

        public override function result(data:Object):void
        {
            var xml:XML = ResultEvent(data).result as XML;

            model.session = SessionFactory.buildSessionFromXML(xml);
            model.appViewList = SessionFactory.buildLookupListFromXML(xml.view);

            // now that information has been obtained from the local facility
            // post this event to get the main server info and start the application
            new TrackingEvent(TrackingEvent.EVENT_INIT_TRACKING).dispatch();
        }

        protected override function getFaultMessage(fault:FaultEvent) : String {
            return "Unable to get user profile.";
        }

        protected override function createFaultDetail(fault:FaultEvent) : Object {
            var detail:Object = super.createFaultDetail(fault);
            detail.callPrefix = ﻿Services(ServiceLocator.getInstance()).callPrefix;
            detail.callMode = ﻿Services(ServiceLocator.getInstance()).callMode;
            return detail;
        }
    }
}