/*  RemoveLogEntryCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.RemoveLogEntryDelegate;
	import gov.va.med.edp.control.RemoveLogEntryEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class RemoveLogEntryCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate:RemoveLogEntryDelegate = new RemoveLogEntryDelegate(this);
			var removeEvent: RemoveLogEntryEvent = RemoveLogEntryEvent(event);

			delegate.removeLogEntry(model.logEdit.entry, model.logArea);
			model.logEdit.dirty = false;
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;

			// bail if the update of the changed log entry failed
			if (xml.upd.@status == "fail") {
				InfoDialog.show("Removal of log entry failed.\n" + xml.upd.@msg);
				return;
			}
			
			// clear the current record
			model.logEdit.resetEntry();
			model.logEdit.message = "Patient removed from board.";
			model.logEntryViewState = TrackingModelLocator.VIEW_EDIT_MESSAGE;
			model.logEntryList.selectedIndex = -1;
			model.logEntryList.selectedID = 0;
						
			// refresh the list of log entries
			model.logEntryList.entries =
				new ArrayCollection(TrackingFactory.buildLogSelectorListFromXML(xml.logEntries.log));
			model.logEntryList.token = xml.logEntries.@token;
				
			// sort based on previous settings
			if (model.logEntryList.sortField.length > 0) {
				var sort:Sort = new Sort();
				sort.fields = [new SortField(model.logEntryList.sortField, true, model.logEntryList.sortDescending)];
				model.logEntryList.entries.sort = sort;
				model.logEntryList.entries.refresh();
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Remove patient entry failed: " + super.getFaultMessage(faultEvent);
		}
		
	}
}