/* SaveSelectionConfigCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.SaveSelectionConfigDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.widget.InfoDialog;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class SaveSelectionConfigCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent): void
		{
			var newStatuses: ArrayCollection;
			var newDispositions: ArrayCollection;
			var newDelays: ArrayCollection;
			var newArrivals: ArrayCollection;
						
			if (model.config.statusesChanged) {
				newStatuses = model.config.statuses;
			}
			if (model.config.dispositionsChanged) {
				newDispositions = model.config.dispositions;
			}
			if (model.config.delaysChanged) {
				newDelays = model.config.delays;
			}
			if (model.config.arrivalsChanged) {
				newArrivals = model.config.arrivals;
			}
			
			model.config.selectionConfigLoaded = false;
			var delegate: SaveSelectionConfigDelegate = new SaveSelectionConfigDelegate(this);
			delegate.saveSelectionConfig(model.logArea, model.config.selectionToken,
				newStatuses, newDispositions, newDelays, newArrivals);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			if ((xml.save.@status == "ok") || (xml.save.@status == "collide")) {
				BoardTools.applySelectionLists(model.config, xml);
				model.config.selectionConfigLoaded = true;
				
				if (xml.save.@status == "ok") {
					InfoDialog.show("New selection configuration saved.");
				} else {
					InfoDialog.show("Save failed: " + xml.save);
				}
			}
			
			if (xml.save.@status == "fail") {
				InfoDialog.show("Save failed: " + xml.save);
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error saving configuration for selections: " + super.getFaultMessage(faultEvent);
		}
	}
}