/* LoadMissedOpReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.reports.ReportDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;

	public class BaseReportCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		protected var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		private static const REPORT_DT_FORMAT: String = "MM/DD/YYYY JJ:NN";
					
		public function execute(event:CairngormEvent):void
		{
			var delegate: ReportDelegate = new ReportDelegate(this);
			var reportEvent: ReportEvent = ReportEvent(event);
			delegate.loadReport(reportEvent);
			if (reportEvent.reportParams.startDate != null && reportEvent.reportParams.stopDate != null)
			{
				model.reports.startDate = reportEvent.reportParams.startDate;
				model.reports.stopDate = reportEvent.reportParams.stopDate;
			}
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error Loading Report: " + super.getFaultMessage(faultEvent);
		}
				
	}
}