/* UpdateStaffEvent.as */

package gov.va.med.edp.control.config
{
	import com.adobe.cairngorm.control.CairngormEvent;

	import flash.events.Event;

	import gov.va.med.edp.vo.StaffMemberVO;

	public class UpdateStaffEvent extends CairngormEvent
	{
		public static const EVENT_ADD_STAFF: String = "AddStaff";
		public static const EVENT_REMOVE_STAFF: String = "RemoveStaff";

		public var staff: StaffMemberVO;

		public function UpdateStaffEvent(type:String, bubbles:Boolean=true, cancelable:Boolean=false)
		{
			super(type, bubbles, cancelable);
		}

		override public function clone():Event
		{
			return new UpdateStaffEvent(type);
		}

        public static function dispatchAdd(staff : StaffMemberVO, role : String) : void {
        	if (staff == null) return;
            var addEvent: UpdateStaffEvent = new UpdateStaffEvent(EVENT_ADD_STAFF);
			addEvent.staff = staff;
			addEvent.staff.role = role;
			addEvent.staff.changed = true;
			addEvent.dispatch();
        }

         public static function dispatchRemove(staff : StaffMemberVO) : void {
         	if (staff == null) return;
            var removeEvent: UpdateStaffEvent = new UpdateStaffEvent(EVENT_REMOVE_STAFF);
			removeEvent.staff = staff;
			removeEvent.dispatch();
        }
    }
}