package gov.va.med.edp.view.config
{
	import gov.va.med.edp.vo.RoomBedVO;
	
	import mx.collections.ArrayCollection;
	import mx.validators.ValidationResult;
	import mx.validators.Validator;
	
	public class DuplicateNameValidator extends Validator
	{
		[Bindable]
		public var beds:ArrayCollection;

		[Bindable]
		public var selectedBed:RoomBedVO;
	
		[Bindable]
		public var field:String;

		private var results:Array;

        public function DuplicateNameValidator() {
            super();
        }
    
    	private function isDuplicate(value:String):Boolean {
    		if (selectedBed == null) return false;
    		var skipIndex:int = beds.getItemIndex(selectedBed);
    		for (var i:int = 0; i < beds.length; i++) {
    			if (i == skipIndex) continue;
                var bed:RoomBedVO = beds[i] as RoomBedVO;
                
                if (bed[field].toLowerCase() == value.toLowerCase()) return true;
            }
            return false;
    	}
    
        override protected function doValidation(value:Object):Array {
            var inputValue:String = String(value);

            results = [];
			results = super.doValidation(value);        
            if (results.length > 0)
                return results;
        
        	if (isDuplicate(inputValue)) {
        		results.push(new ValidationResult(true, null, "duplicate", "Duplicate name is not allowed."));
        		return results;
        	}
        
            return results;
        }

	}
}