/* ColorSelectionVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	public class ColorSelectionVO implements IValueObject
	{
		public var ignore: Boolean = true;
		public var text: uint = 0;
		public var back: uint = 0xffffff;
				
		public function toString(): String
		{
			// in the string form, the first comma piece is 1 if color should be used
			var x: String =
				(ignore ? "0" : "1") + "," +
				"0x" + text.toString(16) + "," +
				"0x" + back.toString(16) + ",";
			return x;
		}
	}
}
