/* RoomBedVO.as */
	
package gov.va.med.edp.vo
{
	import com.adobe.cairngorm.vo.IValueObject;

	[Bindable]
	public class RoomBedVO implements IValueObject
	{
		public var id: int;
		public var area: int;

		public var name: String = "";
		public var inactive: Boolean;
		public var sequence: int;
		public var displayName: String = "";
		public var displayWhen: int;
		public var defaultStatus: int;
		public var category: int;
		public var sharedName: String = "";
		public var boardName: String = "";
		public var color: ColorSelectionVO = new ColorSelectionVO();

		public var changed: Boolean = false;

		public function toString():String
		{
			var x: String =
				"id=" + id + "\t" +
				"area=" + area + "\t" +
				"name=" + name + "\t" +
				"inactive=" + (inactive ? "1" : "0") + "\t" +
				"seq=" + sequence + "\t" +
				"display=" + displayName + "\t" +
				"when=" + displayWhen + "\t" +
				"status=" + defaultStatus + "\t" +
				"category=" + category + "\t" +
				"shared=" + sharedName + "\t" +
				"board=" + boardName + "\t" +
				"color=" + color.toString() + "\t" +
				"changed=" + (changed ? "1" : "0");
			return x;
		}
		
	}
}