package gov.va.med.edp.widget
{
import flash.display.Graphics;

import mx.containers.BoxDirection;
import mx.controls.TabBar;
import mx.core.ClassFactory;
import mx.core.EdgeMetrics;
import mx.core.IFlexDisplayObject;
import mx.core.mx_internal;
import mx.styles.CSSStyleDeclaration;
import mx.styles.StyleManager;
	
use namespace mx_internal;

/**
 *  Name of CSS style declaration that specifies the styles to use for the text
 *  of the selected tab navigation item. 
 * 
 *  @default "selectedLinkStyle" 
 */
[Style(name="selectedTabTextStyleName", type="String", inherit="no")]

/**
 *  Name of CSS style declaration that specifies the styles to use for the tab
 *  navigation items.
 * 
 *  @default "LinkButtonTab"
 */
[Style(name="tabStyleName", type="String", inherit="no")]

/**
 *  Background color of the LinkButton control as you press it.
 * 
 *  @default 0xCDFFC1
 */
[Style(name="selectionColor", type="uint", format="Color", inherit="yes")]

/**
 *  Separator color used by the default separator skin.
 * 
 *  @default 0xC4CCCC
 */
[Style(name="separatorColor", type="uint", format="Color", inherit="yes")]

/**
 *  Separator pixel width, in pixels.
 * 
 *  @default 1
 */
[Style(name="separatorWidth", type="Number", format="Length", inherit="yes")]
		
/**
 *  Number of pixels between tab navigation items in the horizontal direction.
 * 
 *  @default 8
 */
[Style(name="horizontalGap", type="Number", format="Length", inherit="no")]

/**
 *  Number of pixels between tab navigation items in the vertical direction.
 * 
 *  @default 8
 */
[Style(name="verticalGap", type="Number", format="Length", inherit="no")]

[AccessibilityClass(implementation="gov.va.med.edp.widget.accessibility.LinkButtonTabBarAccImpl")]

[DefaultProperty("dataProvider")]

[MaxChildren(0)]
	
public class LinkButtonTabBar extends TabBar
{
    mx_internal static var createAccessibilityImplementation:Function;

    private static var classConstructed:Boolean = classConstruct();
	
	private static function classConstruct():Boolean {
		// If there is no CSS definition for our style,
		// then create one and set the default value.
		if (!StyleManager.getStyleDeclaration(".selectedLinkStyle"))
		{
			var linkStyle:CSSStyleDeclaration = new CSSStyleDeclaration();
			linkStyle.defaultFactory = function():void {
				this.color = 0xAAB3B3;
				this.textRollOverColor = 0xAAB3B3;
			}
			StyleManager.setStyleDeclaration(".selectedLinkStyle", linkStyle, true);
		}
		
		if (!StyleManager.getStyleDeclaration("LinkButtonTabBar"))
		{
			var style:CSSStyleDeclaration = new CSSStyleDeclaration();
			style.defaultFactory = function():void {
				this.tabStyleName = "LinkButtonTab";
				
				this.selectedTabTextStyleName = "selectedLinkStyle";
				
				this.separatorColor = 0xC4CCCC;
				this.separatorWidth = 1;
				this.selectionColor = 0x0000FF;
				
				this.horizontalGap = 8;
				this.verticalGap = 8;
			}
			StyleManager.setStyleDeclaration("LinkButtonTabBar", style, true);
		}
		return true;
	}
	
    public function LinkButtonTabBar()
    {
        super();
        navItemFactory = new ClassFactory(LinkButtonTab);
    }

    override protected function initializeAccessibility():void
    {
        if (LinkButtonTabBar.createAccessibilityImplementation != null)
            LinkButtonTabBar.createAccessibilityImplementation(this);
    }

    override protected function updateDisplayList(unscaledWidth:Number,
                                                  unscaledHeight:Number):void
    {
        // The super method will lay out the LinkButtons.
        super.updateDisplayList(unscaledWidth, unscaledHeight);

		var separatorThickness:Number = getStyle("separatorWidth");
		if (separatorThickness == 0 || separatorThickness == 0) return;
		
		var separatorColor:uint = getStyle("separatorColor");
		
		var vm:EdgeMetrics = viewMetricsAndPadding;

        var horizontalGap:Number = getStyle("horizontalGap");
        var verticalGap:Number = getStyle("verticalGap");

        var barHeight:Number = unscaledHeight - (vm.top + vm.bottom);
        var barWidth:Number = unscaledWidth - (vm.left + vm.right);
		
		var g:Graphics = graphics;
		g.clear();
		
		g.lineStyle(separatorThickness, separatorColor);
		
		var isVertical:Boolean = direction == BoxDirection.VERTICAL;
		
		var x:Number;
        var y:Number;
        var h:Number = isVertical ? verticalGap : barHeight;
        var w:Number = isVertical ? barWidth : horizontalGap;
		
        // paint the separators.
        var n:int = numChildren - 1;
        for (var i:int = 0; i < n; i++)
        {
            var child:IFlexDisplayObject = IFlexDisplayObject(getChildAt(i));
            
            if (isVertical)
			{
            	x = child.x;
            	y = child.y + child.height;
            	g.moveTo(x + 4, y + h / 2);
				g.lineTo(x + w - 4, y + h / 2);
            } else {
            	x = child.x + child.width;
            	y = child.y;
            	g.moveTo(x + w / 2, y + 6);
				g.lineTo(x + w / 2, y + h - 5);
            }
        }
    }

    override public function styleChanged(styleProp:String):void {
        super.styleChanged(styleProp);

        // Check to see if style changed.
        if (styleProp == "separatorColor" || styleProp == "separatorWidth" || styleProp == "selectionColor")
        {
            invalidateDisplayList();
            return;
        }
    }
            
}
}