/* LoadActivityReportCommand.as */
	
package gov.va.med.edp.command.reports
{
	import gov.va.med.edp.control.reports.ReportEvent;
	import gov.va.med.edp.factory.ReportFactory;
	
	import mx.rpc.events.ResultEvent;

	public class LoadBVACReportCommand extends BaseReportCommand
	{
		
		override public function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;	
			// process the xml
			//add summaryVO data to model
			model.reports.bvacReport.bvacReportLogs = ReportFactory.buildBVACLogEntriesFromXML(xml.logEntries.log);
			model.reports.bvacReport.bvacReportAverages = ReportFactory.buildReportAveragesFromXML(xml.averages.average);						
			//fire the binding..
			model.reports.reportType = "";
			model.reports.reportType = ReportEvent.EVENT_BVAC_REPORT;
		}
		
	}
}