package gov.va.med.edp.pt.demog.dao {
import mx.rpc.IResponder;
import gov.va.med.edp.business.LogSensitivePatientAccessDelegate;
import gov.va.med.edp.business.CheckSensitivePtAndFlagsDelegate;
import gov.va.med.edp.pt.demog.model.PatientSelectVO;
import gov.va.med.edp.pt.demog.IPatientChecksDao;
public class CairngormPatientChecksDao implements IPatientChecksDao {

    [Bindable]
    public var logArea:int;

    public function loadPatientChecks(responder:IResponder, pt:PatientSelectVO):void {
        var delegate: CheckSensitivePtAndFlagsDelegate = new CheckSensitivePtAndFlagsDelegate(responder);
        delegate.checkSensitivePtAndFlags(logArea, pt.dfn, pt.name);
    }

    public function logPatientAccess(responder:IResponder, dfn:String):void {
        var delegate:LogSensitivePatientAccessDelegate = new LogSensitivePatientAccessDelegate(responder);
        delegate.logSensitivePatientAccess(dfn);
    }
}
}