package gov.va.med.edp.pt.demog.model {
import gov.va.med.edp.pt.demog.model.PatientCheckVO;
[Bindable]
public class PatientChecksModel {
    public static const STATE_NONE: int = 0;
    public static const STATE_LOADING: int = 1;
    public static const STATE_LOADED: int = 2;

    public static const STATE_ONBOARD: int = 10;
    public static const STATE_SIMILAR: int = 11;
    public static const STATE_SENSITIVE: int = 12;
    public static const STATE_DECEASED: int = 13;
    public static const STATE_FLAGS: int = 14;

    public static const STATE_ALLOW: int = 22;

    public var checkState: int = STATE_NONE;

    public var patientChecks: PatientCheckVO;

	public var checksForPt:PatientSelectVO;

    public var backEnabled:Boolean = false;

    public var continueEnabled:Boolean = false;

    private var _patientChecksReady: Boolean = false;

    public function get patientChecksReady():Boolean {
        return _patientChecksReady;
    }

    public function set patientChecksReady(b:Boolean):void {
        this._patientChecksReady = b;
        if (b && checkState == STATE_LOADING) {
            checkState = STATE_LOADED;
            continueEnabled = true;
        }
    }

    public function reset():void {
        patientChecks = null;
		checksForPt = null;
		checkState = STATE_NONE;
        patientChecksReady = false;
        continueEnabled = false;
        backEnabled = false;
    }

    public function back():void {
        if (!backEnabled) return;

        if (!continueEnabled) continueEnabled = true;

        if (checkState > STATE_DECEASED && patientChecks.isDeceased()) {
            checkState = STATE_DECEASED;
        } else if (checkState > STATE_SENSITIVE && patientChecks.sensitive) {
            checkState = STATE_SENSITIVE;
        } else if (checkState > STATE_SIMILAR && patientChecks.hasSimilarNames()) {
            checkState = STATE_SIMILAR;
        } else if (checkState > STATE_LOADED) {
            checkState = STATE_LOADED;
            backEnabled = false;
        }
    }

    public function forward():void {
        if (!continueEnabled) return;

        if (!backEnabled) backEnabled = true;

        if (checkState < STATE_ONBOARD && patientChecks.isOnBoard()) {
            checkState = STATE_ONBOARD;
            continueEnabled = false;
        } else if (checkState < STATE_SIMILAR &&
                   patientChecks.hasSimilarNames()) {
            checkState = STATE_SIMILAR;
        } else if (checkState < STATE_SENSITIVE && patientChecks.sensitive) {
            checkState = STATE_SENSITIVE;
            if (!patientChecks.mayAccess) continueEnabled = false;
        } else if (checkState < STATE_DECEASED && patientChecks.isDeceased()) {
            checkState = STATE_DECEASED;
        } else if (checkState < STATE_FLAGS && patientChecks.hasFlags()) {
            checkState = STATE_FLAGS;
        } else {
            checkState = STATE_ALLOW;
            backEnabled = false;
            continueEnabled = false;
        }
    }
}
}