package gov.va.med.edp.util
{
	import flash.events.Event;
	
	import gov.va.med.edp.control.ChangeLogEntryFieldEvent;
	import gov.va.med.edp.pt.demog.view.SelectPatientEvent;

	import mx.controls.ComboBox;
	import mx.controls.TextInput;
	import mx.events.CalendarLayoutChangeEvent;

	public class ChangeWatcher
	{
		public static function changeField(event: Event): void
		{
			var changeEvent: ChangeLogEntryFieldEvent = 
				new ChangeLogEntryFieldEvent(ChangeLogEntryFieldEvent.EVENT_CHANGE_LOG_ENTRY_FIELD);
			changeEvent.field = event.currentTarget.id;
			if (event.currentTarget is ComboBox) {
				changeEvent.value = comboBoxValue(ComboBox(event.currentTarget));
				changeEvent.label = comboBoxLabel(ComboBox(event.currentTarget));
				changeEvent.reference = comboBoxRef(ComboBox(event.currentTarget));
			}
			if (event.currentTarget is TextInput) {
				changeEvent.value = TextInput(event.currentTarget).text;
				//changeEvent.value = (changeEvent.value == "") ? "   " : changeEvent.value;
				changeEvent.label = changeEvent.value;
			}
			if (event is SelectPatientEvent) {
				changeEvent.value = SelectPatientEvent(event).patient;
				changeEvent.field = "patient";
			}
			if (event is CalendarLayoutChangeEvent) {
				changeEvent.value = CalendarLayoutChangeEvent(event).newDate;
				changeEvent.field = event.currentTarget.id;
			}
			changeEvent.dispatch();
		}
		
		private static function comboBoxValue(box: ComboBox): *
		{
			if (box.selectedItem == null) return -1;
			return box.selectedItem.data;
		}
		
		private static function comboBoxLabel(box: ComboBox): String
		{
			if (box.selectedItem == null) return "";
			return box.selectedItem.label;
		}
		
		private static function comboBoxRef(box: ComboBox): String
		{
			if (box.selectedItem == null) return "";
			if (box.selectedItem.hasOwnProperty("reference")) {
				return box.selectedItem.reference;
			} else {
				return "";
			}
		}
	}
}