package gov.va.med.edp.vistalink;

import org.springframework.dao.support.DaoSupport;
import gov.va.med.edp.vistalink.locator.InstitutionMappingConnectionFactoryLocator;

public class VistaLinkDaoSupport extends DaoSupport {

    private VistaLinkTemplate rpcTemplate;

    protected void checkDaoConfig() throws IllegalArgumentException {
        if (this.rpcTemplate == null) {
			setConnectionFactoryLocator(new InstitutionMappingConnectionFactoryLocator());
		}
    }

    protected VistaLinkTemplate createRpcTemplate(ConnectionFactoryLocator connectionFactoryLocator) {
        return new VistaLinkTemplate(connectionFactoryLocator);
    }

    public ConnectionFactoryLocator getConnectionFactoryLocator() {
        return rpcTemplate.getConnectionFactoryLocator();
    }

    public void setConnectionFactoryLocator(ConnectionFactoryLocator connectionFactoryLocator) {
        setRpcTemplate(createRpcTemplate(connectionFactoryLocator));
    }

    public VistaLinkTemplate getRpcTemplate() {
        return rpcTemplate;
    }

    public void setRpcTemplate(VistaLinkTemplate rpcTemplate) {
        this.rpcTemplate = rpcTemplate;
    }
}
