/* SwitchAppViewCommand.as */

package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.control.SwitchAppViewEvent;

	public class SwitchAppViewCommand implements ICommand
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		public function execute(event:CairngormEvent):void
		{
			var viewEvent: SwitchAppViewEvent = SwitchAppViewEvent(event);
			
			if ((viewEvent.view == TrackingModelLocator.VIEW_APP_EDIT_CLOSED) &&
			    (model.appViewState != TrackingModelLocator.VIEW_APP_EDIT_CLOSED)) {
				model.logEdit.resetEntry();
				model.logEntryList.resetSelection();
			}
			
			if (model.logEdit.entry == null) {
				model.logEdit.message = "No visit currently selected.";
			}
			
			model.appViewState = viewEvent.view;
			model.setEditState();
		}
	}
}