/* ReportParamsVO.as */
	
package gov.va.med.edp.vo.reports
{
	import com.adobe.cairngorm.vo.IValueObject;
	
	import gov.va.med.edp.util.Vista;

	[Bindable]
	public class ReportParamsVO implements IValueObject
	{
		public var reportName: String;
		public var id: String;
		public var startDate: Date;
		public var stopDate: Date;
		
		public function toString():String
		{
				var x: String = "reportName=" + reportName + "\t" +
				"id=" + id + "\t" +
				"startDate=" + Vista.DatetoFM(startDate) + "\t" +
				"stopDate=" + Vista.DatetoFM(stopDate);
				return x;
		}	
	
	}
}