package gov.va.med.edp.pt.demog.control {
import mx.rpc.IResponder;
import gov.va.med.edp.pt.demog.IPatientChecksDao;
import gov.va.med.edp.pt.demog.model.PatientSelectVO;
import gov.va.med.edp.pt.demog.model.PatientCheckVO;
import gov.va.med.edp.pt.demog.model.PatientChecksModel;

import flexunit.framework.TestCase;

public class TestPatientChecksController extends TestCase implements IPatientChecksDao {

    private var loadCalledWithThisPt:PatientSelectVO;
    private var logAccessCalledWithThisDfn:String;

    public function testResetPatientChecks():void {
        var model:PatientChecksModel = new PatientChecksModel();
        model.patientChecks = new PatientCheckVO();
        model.patientChecksReady = true;

        var c:PatientChecksController = new PatientChecksController();
        c.model = model;

        c.resetPatientChecks();

        assertNull(model.patientChecks);
        assertFalse(model.patientChecksReady);
    }

    public function testLoadPatientChecks():void {
        var model:PatientChecksModel = new PatientChecksModel();
        var c:PatientChecksController = new PatientChecksController();
        c.model = model;
        c.dao = this;

        var pt:PatientSelectVO = new PatientSelectVO();
        pt.dfn = "FOO";
        pt.name = "BAR";

        c.loadPatientChecks(pt);

        assertEquals(PatientChecksModel.STATE_LOADING, model.checkState);
        assertFalse(model.patientChecksReady);
        assertTrue(pt === loadCalledWithThisPt);
    }

    public function testLogSensitivePatientAccess():void {
        var model:PatientChecksModel = new PatientChecksModel();
        model.checkState = PatientChecksModel.STATE_LOADING;
        model.patientChecks = new PatientCheckVO();
        model.patientChecks.dfn = "foobar";
        model.patientChecks.sensitive = true;
        model.patientChecks.warningText = "Patient FOO,BAR is sensitive.  Continue";
        model.patientChecks.logAccess = true;
        model.patientChecksReady = true;

        var c:PatientChecksController = new PatientChecksController();
        c.model = model;
        c.dao = this;

        c.forwardPatientCheck();
        assertEquals(PatientChecksModel.STATE_SENSITIVE, model.checkState);

        c.forwardPatientCheck();
        assertEquals("foobar", logAccessCalledWithThisDfn);
    }

    //
    // methods to mock the patient checks DAO
    //
    public function loadPatientChecks(responder:IResponder, pt:PatientSelectVO):void {
        loadCalledWithThisPt = pt;
    }

    public function logPatientAccess(responder:IResponder, dfn:String):void {
        logAccessCalledWithThisDfn = dfn;
    }
}
}