<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
    <title><fmt:message key="app.name"/> - Version Incompatibility</title>
    <script language="JavaScript">
        var targetURL = '<c:url value="/"/>';
        var countdownfrom = 30;
        var currentsecond;
        
        function init() {
            currentsecond = document.getElementById('countdown').innerHTML = countdownfrom + 1;
            countredirect();
        }

        function countredirect() {
            if (currentsecond != 1) {
                currentsecond -= 1;
                document.getElementById('countdown').innerHTML = currentsecond;
            }
            else {
                window.location = targetURL;
                return
            }
            setTimeout("countredirect()", 1000);
        }
    </script>
</head>
<body onload="init()">
<%session.invalidate();%>
<h2>
    <fmt:message key="app.name"/>
</h2>

<h3>Version Incompatibility</h3>

<p>This is EDIS web application version '<fmt:message key="app.version"/>'.<br/>
    The EDIS server package version running in your VistA account is '<c:out value="${serverPackageVersion}"/>'.<br/>
    A compatible client ('<c:out value="${clientFinalName}"/>') was not found bundled in this web application.
</p>

<p>Please ensure the version in your VistA account is compatible with version '<fmt:message key="app.version"/>' of the
    EDIS web application.</p>

<p>Will attempt to re-establish connection in <span id="countdown">XX</span> seconds.</p>
</body>
</html>