package gov.va.med.edp.springframework.security.userdetails.vistalink;

import gov.va.med.edp.springframework.security.userdetails.VistaUserDetails;
import org.springframework.security.GrantedAuthority;

public class VistaUser implements VistaUserDetails {

    private String loginStationNumber;
    private String signonLogInternalEntryNumber;
    private String duz;
    private String accessCode;
    private String verifyCode;
    private String personName;
    private String displayName;
    private String givenName;
    private String middleName;
    private String familyName;
    private String prefix;
    private String suffix;
    private String degree;
    private GrantedAuthority[] authorities;

//    private SortedMap<String, VistaDivision> permittedDivisions;

    public VistaUser(String signonLogInternalEntryNumber, String loginStationNumber, String duz, String accessCode, String verifyCode, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, GrantedAuthority[] authorities) {
        this(signonLogInternalEntryNumber, loginStationNumber, duz, accessCode, verifyCode, null, null,null,null,null,null,null,null,enabled, accountNonExpired, accountNonLocked, credentialsNonExpired, authorities);
    }

    public VistaUser(String signonLogInternalEntryNumber, String loginStationNumber, String duz, String accessCode, String verifyCode, String personName, String displayName, String givenName, String middleName, String familyName, String prefix, String suffix, String degree, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, GrantedAuthority[] authorities) {
        if (duz == null) throw new IllegalArgumentException();
        if (loginStationNumber == null) throw new IllegalArgumentException();
        if (signonLogInternalEntryNumber == null) throw new IllegalArgumentException();
        if (authorities == null) throw new IllegalArgumentException();
        this.duz = duz;
        this.accessCode = accessCode;
        this.verifyCode = verifyCode;
        this.personName = personName;
        this.displayName = displayName;
        this.givenName = givenName;
        this.middleName = middleName;
        this.familyName = familyName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.degree = degree;
        this.loginStationNumber = loginStationNumber;
        this.signonLogInternalEntryNumber = signonLogInternalEntryNumber;
        this.authorities = authorities;
    }

    public GrantedAuthority[] getAuthorities() {
        return authorities;
    }

    public String getPassword() {
        return this.accessCode + ";" + this.verifyCode;
    }

    public String getUsername() {
        return getDuz() + "@" + getLoginStationNumber();
    }

    public boolean isAccountNonExpired() {
        return true;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public boolean isAccountNonLocked() {
        return true;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public boolean isCredentialsNonExpired() {
        return true;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public boolean isEnabled() {
        return true;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public String getDuz() {
        return duz;
    }

    public String getGivenName() {
        return givenName;
    }

    public String getMiddleName() {
        return middleName;
    }

    public String getFamilyName() {
        return familyName;
    }

    public String getPrefix() {
        return prefix;
    }

    public String getSuffix() {
        return suffix;
    }

    public String getDegree() {
        return degree;
    }

    public String getLoginStationNumber() {
        return loginStationNumber;
    }

    public String getSignonLogInternalEntryNumber() {
        return signonLogInternalEntryNumber;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }
}
