
package gov.va.med.edp.command.reports
{
	import com.adobe.cairngorm.business.ServiceLocator;
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.FileReference;
	import flash.net.URLRequest;
	
	import gov.va.med.edp.business.CSPService;
	import gov.va.med.edp.control.reports.ReportDownloadEvent;
	import gov.va.med.edp.util.Vista;
	import gov.va.med.edp.widget.InfoDialog;
	
	public class DownloadReportCommand implements ICommand
	{	
		private var fr:FileReference = new FileReference();
		
		public function execute(event:CairngormEvent):void
		{
            fr.addEventListener(Event.OPEN, openHandler);
            fr.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            fr.addEventListener(Event.COMPLETE, completeHandler);	

			var reportEvent: ReportDownloadEvent = ReportDownloadEvent(event);
			var service:CSPService = ServiceLocator.getInstance().getHTTPService("downloadReports") as CSPService;
			var startFMDate:String = Vista.DatetoFM(reportEvent.reportParams.startDate);
			var endFMDate:String = Vista.DatetoFM(reportEvent.reportParams.stopDate);
			
			var urlPrefix:String = "";
			
			if (service.callType == CSPService.SERVICE_USE_VLJ){
				urlPrefix = service.vlj;
			} else if (service.callType == CSPService.SERVICE_USE_CSP){
				urlPrefix = service.csp;
			}
			
			var completeUrl: String = urlPrefix + "?command=" + service.command + "&report=" + reportEvent.reportParams.reportName.toLowerCase() + 
									"&start=" + startFMDate + "&stop=" + endFMDate + "&id=" + reportEvent.reportParams.id;
									  
            var request:URLRequest = new URLRequest(completeUrl);
            var fileName:String = reportEvent.reportParams.reportName + "Report.xls";

           fr.download(request, fileName);
 				
		}

        private function completeHandler(event:Event):void {
			InfoDialog.show("Download Complete");
        }
        
        private function errorHandler(event:Event):void {
			InfoDialog.show("An error occured while downloading the file" + event.currentTarget.toString());
        }
        
        private function openHandler(event:Event):void {
			trace("Dialog Opened");
        }


	}
}