/* TrackingController.as */

package gov.va.med.edp.control
{
	import com.adobe.cairngorm.control.FrontController;
	
	import gov.va.med.edp.command.*;
	import gov.va.med.edp.command.config.*;
	import gov.va.med.edp.command.reports.*;
	import gov.va.med.edp.control.config.*;
	import gov.va.med.edp.control.reports.ReportDownloadEvent;
	import gov.va.med.edp.control.reports.ReportEvent;

	public class TrackingController extends FrontController
	{
		public function TrackingController()
		{
			initializeCommands();
		}
		
		public function initializeCommands():void
		{
			addCommand(InitAppEvent.EVENT_INIT_APP, InitAppCommand);
			addCommand(TrackingEvent.EVENT_INIT_TRACKING, InitTrackingCommand);
			addCommand(SwitchAppViewEvent.EVENT_SWITCH_APP_VIEW, SwitchAppViewCommand);
			addCommand(TrackingEvent.EVENT_REFRESH_LOG_SELECTOR, RefreshLogSelectorCommand);
			addCommand(SwitchLogEntryEvent.EVENT_SWITCH_LOG_ENTRY, SwitchLogEntryCommand);
			addCommand(TrackingEvent.EVENT_SAVE_LOG_ENTRY, SaveLogEntryCommand);
			addCommand(TrackingEvent.EVENT_CANCEL_EDIT, CancelLogEntryEditCommand);
			addCommand(TrackingEvent.EVENT_DELETE_STUB_ENTRY, DeleteStubEntryCommand);
			addCommand(MatchItemsEvent.EVENT_MATCH_CLOSED_VISITS, MatchClosedVisitsCommand);
			addCommand(InitLogAreaEvent.EVENT_INIT_LOG_AREA, InitLogAreaCommand);
			addCommand(PatientSelectEvent.EVENT_ADD_PATIENT_TO_LOG, AddPatientToLogCommand);
			addCommand(ChangeLogEntryFieldEvent.EVENT_CHANGE_LOG_ENTRY_FIELD, ChangeLogEntryFieldCommand);
			addCommand(DisplayBoardEvent.EVENT_INIT_DISPLAY_BOARD, InitDisplayBoardCommand);
			addCommand(DisplayBoardEvent.EVENT_REFRESH_DISPLAY_BOARD, RefreshDisplayBoardCommand);
			addCommand(RemoveLogEntryEvent.EVENT_REMOVE_LOG_ENTRY, RemoveLogEntryCommand);
			addCommand(SortHeaderEvent.EVENT_SORT_DISPLAY_BOARD, SortHeaderCommand);
			addCommand(SortHeaderEvent.EVENT_SORT_LOG_SELECTOR, SortHeaderCommand);
			addCommand(ConfigurationEvent.EVENT_LOAD_CONFIGURATION, LoadConfigurationCommand);
			addCommand(ConfigurationEvent.EVENT_LOAD_STAFF_CONFIG, LoadConfigStaffCommand);
			addCommand(BoardConfigEvent.EVENT_ADD_CONFIG_BOARD, AddBoardCommand);
			addCommand(BoardConfigEvent.EVENT_LOAD_CONFIG_BOARD, LoadBoardConfigCommand);
			addCommand(BoardConfigEvent.EVENT_SAVE_CONFIG_BOARD, SaveConfigBoardCommand);
			addCommand(SaveBedConfigEvent.EVENT_SAVE_CONFIG_BEDS, SaveBedConfigCommand);
			addCommand(ConfigurationEvent.EVENT_SAVE_COLOR_CONFIG, SaveConfigColorsCommand);
			addCommand(ConfigurationEvent.EVENT_SAVE_PARAM_CONFIG, SaveConfigParamsCommand);
			addCommand(ConfigurationEvent.EVENT_SAVE_STAFF_CONFIG, SaveConfigStaffCommand);
			addCommand(ConfigurationEvent.EVENT_LOAD_SELECTION_CONFIG, LoadSelectionConfigCommand);
			addCommand(ConfigurationEvent.EVENT_SAVE_SELECTION_CONFIG, SaveSelectionConfigCommand);
			addCommand(ConfigurationEvent.EVENT_BED_MODIFIED, SetModifiedCommand);
			addCommand(ConfigurationEvent.EVENT_BOARD_MODIFIED, SetModifiedCommand);
			addCommand(ConfigurationEvent.EVENT_COLOR_MODIFIED, SetModifiedCommand);
			addCommand(ConfigurationEvent.EVENT_PARAM_MODIFIED, SetModifiedCommand);
			addCommand(ConfigurationEvent.EVENT_PARAM_MODIFIED_RESET, SetModifiedCommand);
			addCommand(ConfigurationEvent.EVENT_SELECTION_MODIFIED, SetModifiedCommand);
			addCommand(ConfigurationEvent.EVENT_STAFF_MODIFIED, SetModifiedCommand);
			addCommand(ConfigAddColumnEvent.EVENT_CONFIG_ADD_COLUMN, ConfigAddColumnCommand);
			addCommand(ConfigRemoveColumnEvent.EVENT_CONFIG_REMOVE_COLUMN, ConfigRemoveColumnCommand);
			addCommand(ConfigChangeColumnEvent.EVENT_CONFIG_CHANGE_COLUMN_SEQ, ConfigChangeColumnCommand);
			addCommand(ConfigChangeColumnEvent.EVENT_CONFIG_CHANGE_COLUMN_WIDTH, ConfigChangeColumnCommand);
			addCommand(ConfigChangeColumnEvent.EVENT_CONFIG_CHANGE_ROW_COLOR, ConfigChangeColumnCommand);
			addCommand(ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_FONT_SIZE, ConfigChangeDisplayBoardPropertiesCommand);
			addCommand(ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_DISPLAY_WIDTH, ConfigChangeDisplayBoardPropertiesCommand);
			addCommand(ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_SCROLL_DELAY, ConfigChangeDisplayBoardPropertiesCommand);
			addCommand(ConfigChangeDisplayBoardPropertiesEvent.EVENT_CONFIG_CHANGE_SQUISH, ConfigChangeDisplayBoardPropertiesCommand);
			addCommand(ChangeBedSequenceEvent.EVENT_CHANGE_BED_SEQUENCE, ChangeBedSequenceCommand);
			addCommand(NumberEvent.EVENT_CHANGE_SQUISH_FONT_SIZE, ChangeFontSizeCommand);
			addCommand(UpdateStaffEvent.EVENT_ADD_STAFF, UpdateStaffCommand);
			addCommand(UpdateStaffEvent.EVENT_REMOVE_STAFF, UpdateStaffCommand);
			addCommand(MatchPersonEvent.EVENT_MATCH_PERSON, MatchPersonCommand);
			addCommand(AddBedEvent.EVENT_ADD_BED, AddBedCommand);
			addCommand(ChangeFieldEvent.EVENT_CHANGE_PARAM_FIELD, ChangeParamFieldCommand);
			addCommand(ReportEvent.EVENT_ACTIVITY_REPORT, LoadActivityReportCommand);
			addCommand(ReportEvent.EVENT_ACUITY_REPORT, LoadAcuityReportCommand);
			addCommand(ReportEvent.EVENT_DELAY_REPORT, LoadDelayReportCommand);
			addCommand(ReportEvent.EVENT_SUMMARY_REPORT, LoadSummaryReportCommand);
			addCommand(ReportEvent.EVENT_MISSED_OP_REPORT, LoadMissedOpReportCommand);
			addCommand(ReportEvent.EVENT_SHIFT_REPORT, LoadShiftReportCommand);
			addCommand(ReportEvent.EVENT_PATIENT_XREF_REPORT, LoadPatientXRefReportCommand);
			addCommand(ReportEvent.EVENT_VA_ADMISSIONS_REPORT, LoadVaAdmissionsReportCommand);
			addCommand(ReportEvent.EVENT_PROVIDER_REPORT, LoadProviderReportCommand);
			addCommand(ReportEvent.EVENT_BVAC_REPORT, LoadBVACReportCommand);
			addCommand(ReportEvent.EVENT_ORDERS_BY_ACUITY_REPORT, LoadOrdersByAcuityReportCommand);
			addCommand(ReportDownloadEvent.EVENT_DOWNLOAD_REPORT, DownloadReportCommand);
			addCommand(ReportEvent.EVENT_EXPOSURE_REPORT, LoadExposureReportCommand);
			addCommand(ReportEvent.EVENT_PATIENT_INTAKE_REPORT, LoadPtIntakeReportCommand);
			addCommand(MatchItemsEvent.EVENT_MATCH_DIAGNOSES, MatchDiagnosesCommand);
			addCommand(ClearUnsavedViewsModelEvent.EVENT_CLEAR_UNSAVED_VIEWS, ClearUnsavedViewsModelCommand);
		}
	}
}