package gov.va.med.edp.pt.demog.control
{
import gov.va.med.edp.pt.demog.IPatientChecksController;
import gov.va.med.edp.pt.demog.model.PatientSelectVO;
import gov.va.med.edp.pt.demog.model.PatientChecksModel;
import gov.va.med.edp.pt.demog.dao.PatientXml;
import gov.va.med.edp.command.AbstractResponderCommand;
import mx.rpc.IResponder;
import mx.rpc.events.FaultEvent;
import mx.rpc.events.ResultEvent;

public class CheckSensitivePtAndFlagsResponder extends AbstractResponderCommand implements IResponder
{
	private var cntrl:IPatientChecksController;
	private var model:PatientChecksModel;
	private var checksForPt:PatientSelectVO;
	private var forwardOnLoad:Boolean;

	public function CheckSensitivePtAndFlagsResponder(cntrl:IPatientChecksController, model:PatientChecksModel, pt:PatientSelectVO, forwardOnLoad:Boolean = false):void {
		this.cntrl = cntrl;
		this.model = model;
		this.checksForPt = pt;
		this.forwardOnLoad = forwardOnLoad;
	}

	public override function result(data:Object):void
	{
		var xml:XML = ResultEvent(data).result as XML;
		model.patientChecks = PatientXml.buildPtChecksFromXML(xml);
		model.checksForPt = checksForPt;
		model.patientChecksReady = true;
		if (forwardOnLoad) {
			cntrl.forwardPatientCheck();
		}
	}

	protected override function getFaultMessage(faultEvent:FaultEvent):String {
		return "command for patient selection checks failed: " + super.getFaultMessage(faultEvent);
	}
}
}