package gov.va.med.edp.pt.demog.dao {
import gov.va.med.edp.util.Vista;
import gov.va.med.edp.pt.demog.model.PatientRecordFlagVO;
import gov.va.med.edp.factory.TrackingFactory;
import gov.va.med.edp.pt.demog.model.PatientCheckVO;

import gov.va.med.edp.pt.demog.model.PatientSelectVO;
import mx.collections.ArrayCollection;

public class PatientXml {
    /* buildLookupPatientListFromXML expects:
     <anyRoot>
     <anyNode dfn="999" ptNm="XXXX" ssn="999999999" dob="mmm dd,yyyy" />
     ...
     </anyRoot> */
    public static function buildLookupPatientListFromXML(xml:XML): ArrayCollection
    {
        var patientSelectVO: PatientSelectVO;
        var patientSelectList: ArrayCollection = new ArrayCollection();
        for each (var item:XML in xml.children()) {
            patientSelectVO = new PatientSelectVO();
            patientSelectVO.dfn = item.@dfn;
            patientSelectVO.name = item.@name;
            patientSelectVO.ssn = item.@ssn;
            patientSelectVO.dob = item.@dob;
            patientSelectList.addItem(patientSelectVO);
        }
        return patientSelectList;
    }

    public static function buildPtChecksFromXML(xml: XML): PatientCheckVO
    {
        var ptCheck: PatientCheckVO = new PatientCheckVO();
        ptCheck.dfn = xml.checks[0].@dfn;
        ptCheck.sensitive = (xml.checks[0].@sensitive == "1");
        ptCheck.mayAccess = (xml.checks[0].@mayAccess == "1");
        ptCheck.logAccess = (xml.checks[0].@logAccess == "1");
        ptCheck.deceasedText = xml.died;
        ptCheck.onBoardText = xml.checks[0].@onBoard;
        ptCheck.warningText = xml.warning;
        ptCheck.similarText = xml.warnSimilar;
        ptCheck.similarNames = buildPatientSelectListFromXML(xml.similar);
        ptCheck.flags = buildPtRecordFlagsFromXML(xml.patientRecordFlags.flag);
        return ptCheck;
    }

    public static function buildPatientSelectListFromXML(nodeList: XMLList): Array
    {
        var ptSel: PatientSelectVO;
        var list: Array = [];
        for each (var item: XML in nodeList) {
            ptSel = new PatientSelectVO();
            ptSel.dfn = item.@dfn;
            ptSel.name = item.@name;
            ptSel.dob = item.@dob;
            ptSel.ssn = item.@ssn;
            list.push(ptSel);
        }
        return list;
    }

    public static function buildPtRecordFlagsFromXML(nodeList: XMLList): ArrayCollection
    {
        var list: ArrayCollection = new ArrayCollection();
        for each (var item: XML in nodeList) {
            var ptRecordFlag: PatientRecordFlagVO = new PatientRecordFlagVO();
            ptRecordFlag.name = item.@name;
            ptRecordFlag.type = item.@type;
            ptRecordFlag.category = item.@category;
            ptRecordFlag.status = item.@assignmentStatus;
            ptRecordFlag.assignDate = Vista.FMtoDate(item.@assignTS);
            ptRecordFlag.approved = item.@approved;
            ptRecordFlag.nextReviewDate = Vista.FMtoDate(item.@nextReviewDT);
            ptRecordFlag.ownerSite = item.@ownerSite;
            ptRecordFlag.originatingSite = item.@originatingSite;
            ptRecordFlag.text = item.text;
            //ptRecordFlag.notes = buildNotesFromXML(item.notes.note);
            list.addItem(ptRecordFlag);
        }
        return list;
    }
}
}