package gov.va.med.edp.vo;

public class SessionVO {

    static final int DEFAULT_TIMEOUT_MS = 300000;   // 5 minutes
    static final int DEFAULT_COUNTDOWN_MS = 10000;  // 10 seconds

    private String serverPackageVersion;
    private int timeOutMillis = DEFAULT_TIMEOUT_MS;
    private int countDownMillis = DEFAULT_COUNTDOWN_MS;

    public String getServerPackageVersion() {
        return serverPackageVersion;
    }

    public void setServerPackageVersion(String serverPackageVersion) {
        this.serverPackageVersion = serverPackageVersion;
    }

    public int getTimeOutMillis() {
        return timeOutMillis;
    }

    public void setTimeOutMillis(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
    }

    public int getCountDownMillis() {
        return countDownMillis;
    }

    public void setCountDownMillis(int countDownMillis) {
        this.countDownMillis = countDownMillis;
    }

    /**
     * Calculates the time, in seconds, between client requests before the servlet container will invalidate this session.
     *
     * @return
     */
    public int getMaxInactiveInterval() {
        return (getTimeOutMillis() + getCountDownMillis()) / 1000 + 60;
    }

    public String toString() {
        return "SessionVO{" +
                "serverPackageVersion='" + serverPackageVersion + '\'' +
                ", timeOutMillis=" + timeOutMillis +
                ", countDownMillis=" + countDownMillis +
                '}';
    }
}
