/* CSPService.as */

package gov.va.med.edp.business
{
	import flash.display.DisplayObject;
	
	import gov.va.med.edp.command.debug.DebugHTTPServiceResponder;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.containers.Panel;
	import mx.controls.Label;
	import mx.core.Application;
	import mx.managers.PopUpManager;
	import mx.rpc.AsyncToken;
	import mx.rpc.IResponder;
	import mx.rpc.http.mxml.HTTPService;

	public class CSPService extends HTTPService implements IResponder
	{
		public var command:String;					// command to pass to CSP Controller
		public var csp:String;						// url for the Cache Server Page
		public var vlj: String						// url for VistALink Call
		public var mock:String;						// file name if using a mock object
		public var callType: int					// determines which call (vlj, csp, mock) to use
		public var block: Boolean = false;
		
		public static const SERVICE_USE_VLJ: int = 0;
		public static const SERVICE_USE_CSP: int = 1
		public static const SERVICE_USE_MOCK: int = 2;		
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
		
		private var _wait: Panel;

		public function CSPService()
		{
			super();
			this.resultFormat = "text";
			this.method = "POST";
			this.requestTimeout = 20;
		}
		
		
		override public function send(parameters:Object=null):AsyncToken
		{
			if ((vlj.length == 0) || (csp.length == 0) || (command.length == 0))
				throw new Error( "csp, vlj and command may not be empty" );
			if (parameters == null)
				parameters = new Object;
			parameters.command = this.command;
            if (Application.application.parameters.swfID != null) parameters.swfID = Application.application.parameters.swfID;
            if (Application.application.parameters.siteId != null)parameters.siteId = Application.application.parameters.siteId;
            switch (callType) {
				case SERVICE_USE_CSP:
					this.url = csp;
					break;
				case SERVICE_USE_MOCK:
					this.url = mock;
					break;
				default:
					this.url = vlj;
					break;
			}
            model.connecting = true;
            //trace(this.url, ": ", this.command);
			var token: AsyncToken = super.send(parameters);
			token.addResponder(this);
            if (this.block) {
				showWaitWindow();
			}
			
			if (model.session != null && model.session.debugEnabled){
				var debugResponder:DebugHTTPServiceResponder = new DebugHTTPServiceResponder(this, parameters);
				token.addResponder(debugResponder);
			}
						
			return token;
		}
		
		private function showWaitWindow(): void
		{
			var label: Label = new Label();
			label.text = "Wait...";
			_wait = 
				Panel(PopUpManager.createPopUp(Application.application as DisplayObject, Panel, true));
			_wait.addChild(label);
			PopUpManager.centerPopUp(_wait);
		}
		
		public function result(data:Object):void
		{
            model.connecting = false;
            if (model.disconnected) model.disconnected = false;
            if (this.block) PopUpManager.removePopUp(_wait);
		}
		
		public function fault(info:Object):void
		{
            model.connecting = false;
            if (this.block) PopUpManager.removePopUp(_wait);
		}

	}
}