package gov.va.med.edp.util
{
	import gov.va.med.edp.factory.SessionFactory;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.Config;
	import gov.va.med.edp.vo.ColorMapVO;
	import gov.va.med.edp.vo.ColorMatchVO;
	import gov.va.med.edp.vo.ColumnSpecVO;
	import gov.va.med.edp.widget.ColorCellRenderer;
	
	import mx.collections.ArrayCollection;
	import mx.controls.DataGrid;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.ClassFactory;
	
	public class BoardTools
	{
		static public function renderPatientName(item:Object, col: DataGridColumn): String
		{
			var name: String = "";
			if (col.dataField == "@last4") {
				name = item.@last4;
			}
			if (col.dataField == "@ptNm") {
				name = item.@ptNm;
			}
			if (item.@similar == "1") {
				name = "*  " + name;
			} else {
				name = "    " + name;
			}
			return name;
		}
			
		static public function buildColumns(spec: ArrayCollection, destGrid: DataGrid): void
		{
			var newCols:Array = new Array();
			var newCol: DataGridColumn;
			for each (var colInfo: ColumnSpecVO in spec) {
				newCol = new DataGridColumn(colInfo.attribute);
				newCol.headerText = colInfo.header;
				newCol.dataField = colInfo.attribute;
				//newCol.width = colInfo.width;
				newCol.itemRenderer = new ClassFactory(gov.va.med.edp.widget.ColorCellRenderer);
				if ((colInfo.attribute == "@last4") || (colInfo.attribute == "@ptNm")) {
					newCol.labelFunction = renderPatientName;
				}
				newCols.push(newCol);
			}
			destGrid.columns = newCols;
			destGrid.invalidateDisplayList();
		}

		
		public static function locateColorMap(id: String, colorMaps: ArrayCollection): ColorMapVO
		{
			for each (var colorMap: ColorMapVO in colorMaps) {
				if (colorMap.id == id) return colorMap;
			}
			return null;
		}
		

		public static function applyColorSpec(nodeList: XMLList, colorMaps: ArrayCollection): void
		{
			for each (var item: XML in nodeList) {
				var colorMap: ColorMapVO = locateColorMap(item.@id, colorMaps);
				if (colorMap == null) continue;
				
				var colorSpecMatches: ArrayCollection = TrackingFactory.buildColorMatchListFromXML(item.map);
				if (colorMap.type == "rng") {
					colorMap.matches = colorSpecMatches;
				}
				
				insertActiveColors(colorMap.matches, colorSpecMatches);
			}
		}
		
		private static function insertActiveColors(baseColors: ArrayCollection, activeColors: ArrayCollection): void
		{
			for each (var match: ColorMatchVO in activeColors) {
				var baseIndex: int = indexOfMatch(match.attribute, match.value, baseColors);
				if (baseIndex > -1) {
					var baseColor: ColorMatchVO = baseColors[baseIndex] as ColorMatchVO;
					baseColor.color = match.color;
				}
			}
		}
		
		private static function indexOfMatch(att: String, val: String, matches: ArrayCollection): int
		{
			for (var i: int = 0; i < matches.length; i++) {
				var match: ColorMatchVO = matches[i] as ColorMatchVO;
				if ((match.attribute == att) && (match.value == val)) {
					return i;
				}
			}
			return -1;
		}
		
		public static function applyBoardSpec(config: Config, xml: XML): void
		{
			// load list of boards
			config.boards = SessionFactory.buildLookupListFromXML(xml.boards.board);
			config.boardIndex = Vista.locateIndex(config.boards, xml.spec.@boardID);
			// load color info for row
			config.rowColorMap = locateColorMap(xml.spec.row.@color, config.colorMaps);
			config.rowColorMapIndex = config.colorMaps.getItemIndex(config.rowColorMap);
			// load actual columns info
			config.columns = TrackingFactory.buildColumnSpecListFromXML(xml.spec.col, config.colorMaps);
			//load screen displayProperties
			config.displayBoardProperties = 
				TrackingFactory.buildDisplayBoardPropertiesFromXML(xml.spec.displayProperties);
			
			config.boardToken = xml.boardToken;
			config.boardMods = false;				
		}
		
		public static function applyStaffLists(config: Config, xml: XML): void
		{
			config.providers = TrackingFactory.buildStaffListFromXML(xml.providers.staff);
			config.residents = TrackingFactory.buildStaffListFromXML(xml.residents.staff);
			config.nurses =  TrackingFactory.buildStaffListFromXML(xml.nurses.staff);
			
			config.providers.filterFunction = hideInactive;
			config.providers.refresh();
			config.residents.filterFunction = hideInactive;
			config.residents.refresh();
			config.nurses.filterFunction = hideInactive;
			config.nurses.refresh();
			
			config.staffToken = xml.staffToken;
			config.staffMods = false;			
		}
		
		public static function hideInactive(item: Object): Boolean
		{
			return (item.inactive == false);
		}
		
		public static function applySelectionLists(config: Config, xml: XML): void
		{
			config.acuities =
				TrackingFactory.buildCodeSelectionListFromXML(xml.acuity.code);
			config.statuses =
				TrackingFactory.buildCodeSelectionListFromXML(xml.status.code);
			config.arrivals =
				TrackingFactory.buildCodeSelectionListFromXML(xml.arrival.code);
			config.dispositions =
				TrackingFactory.buildCodeSelectionListFromXML(xml.disposition.code);
			config.delays =
				TrackingFactory.buildCodeSelectionListFromXML(xml.delay.code);

			config.selectionMods = false;
			config.selectionToken = xml.selectionToken;
		}
		
		public static function displayTimeAsHrsAndMins(item: Object, column: DataGridColumn): String{
			var dataField:String = column.dataField;
			if ((item != null) && (item[dataField] != null)) {
				var time:Number = parseInt(item[dataField]);
				var hours:int = (time/60);
				var minutes:int = ((time%60) * 60)/60;	
				
				var hrString:String = hours.toString();		
				var minString:String = minutes.toString();
				
				if (minutes < 10){
					minString = "0" + minutes.toString();
				}
				var retString:String = hrString + ":" + minString;		        				
				if (hrString == "0" && minString == "00") {
					return "";
				} 
				return hrString + ":" + minString;		        				
			} else {
				return "";
			}
		}
		
/* 		public static function locateColorMapIndex(id: String, colorMaps: ArrayCollection): int
		{
			for (var i: int = 0; i < colorMaps.length; i++) {
				if ((colorMaps[i] as ColorMapVO).id == id) return i;
			}
			return -1;
		}		
 */	}
}