package gov.va.med.edp.widget
{
import mx.events.FlexMouseEvent;
import mx.events.FlexEvent;
import mx.controls.NumericStepper;
import mx.core.mx_internal;
import mx.core.UIComponent;
import mx.managers.IFocusManagerComponent;

import flash.events.FocusEvent;
import flash.events.Event;
import flash.accessibility.AccessibilityProperties;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;
import flash.ui.Keyboard;

use namespace mx_internal;
	
[AccessibilityClass(implementation="gov.va.med.edp.widget.accessibility.NumericStepperAccImpl")]
	 
[Event(name="dataChange", type="mx.events.FlexEvent")]

/**
 *  Dispatched when the user presses the Enter key.
 *
 *  @eventType mx.events.FlexEvent.ENTER
 */
[Event(name="enter", type="mx.events.FlexEvent")]
 
 
[DataBindingInfo("editEvents", "&quot;focusIn;focusOut&quot;stepSizeMouseClickChanged&quot")]

[DefaultBindingProperty(source="text", destination="text")]
   
		  
public class AccessibleNumericStepper extends NumericStepper //implements IFocusManagerComponent
{
	/**
     *  @private
     *  Placeholder for mixin by ComboBoxAccImpl.
     */  
    mx_internal static var createAccessibilityImplementation:Function;
	
	/**
	 * @private
	 */   
	private var iNum:int;
    
    /**
    *  Constructor
    */          
    public function AccessibleNumericStepper()
    {
         super();
         tabChildren = true;
         tabEnabled = true; 
         this.addEventListener(KeyboardEvent.KEY_UP,keyButtonHandler);
         this.addEventListener(MouseEvent.CLICK,buttonClickHandler);
     }
     
     /**
	 *    @protected
	 *    Activates accessibility
	 */ 
     override protected function initializeAccessibility():void
     {
        if (AccessibleNumericStepper.createAccessibilityImplementation != null)
            AccessibleNumericStepper.createAccessibilityImplementation(this);
     }
     
     /**
	  * @protected
	  *  Method that handles focus in events 
	 */   
     override protected function focusInHandler(event:FocusEvent):void 
	 {
	    super.focusInHandler(event);
	    drawFocus(true);
		dispatchEvent(new Event("numericStepperFocused"));
		//event.stopPropagation();
	 }
      
     /**
	  * @private
	  *  Method that handles mouse button click events 
	 */        
     private function buttonClickHandler(event:MouseEvent):void
     {
         dispatchEvent(new Event("stepSizeMouseClickChanged"));
     }
         
     /**
	 * @private
	 *  Method that handles key button down events 
	 */       
     private function keyButtonHandler(event:KeyboardEvent):void
	 {
	     switch (event.keyCode)
         {
             case Keyboard.ENTER:
             {
                 dispatchEvent(new FlexEvent(FlexEvent.ENTER));
                 break;
             }
             case Keyboard.DOWN:
             {
                 dispatchEvent(new FlexEvent(FlexEvent.BUTTON_DOWN));
                 break;
              }
          }
                
	       dispatchEvent(new Event("stepSizeChanged"));
     }
         
         
	 /**
	  *  @private
	  */
	 override public function get tabIndex():int
	 {
	     return iNum;
	 }
	
	 /**
	  *  @private
	  */
	 override public function set tabIndex(value:int):void
	 {
	     iNum = value;
	 }
	
	
	}
}