/* InitDisplayBoardCommand.as */
	
package gov.va.med.edp.command
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.InitDisplayBoardDelegate;
	import gov.va.med.edp.control.DisplayBoardEvent;
	import gov.va.med.edp.factory.TrackingFactory;
	import gov.va.med.edp.model.BigBoardDebugInfo;
	import gov.va.med.edp.model.TrackingModelLocator;
	import gov.va.med.edp.util.BoardTools;
	
	import mx.collections.XMLListCollection;
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class InitDisplayBoardCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate:InitDisplayBoardDelegate = new InitDisplayBoardDelegate(this);
			var initEvent:DisplayBoardEvent = DisplayBoardEvent(event);
			delegate.initDisplayBoard(model.session.area, initEvent.name);
			model.boardSpec.specReady = false;
			model.boardReady = false;
		}
		
		public override function result(data:Object):void
		{
			var xml: XML = ResultEvent(data).result as XML;
			
			// build the color maps first so they can be referenced by columns
			model.boardSpec.colorMaps = TrackingFactory.buildColorMapListFromXML(xml.colorSpec.colors);
			
			// build the column specs
			model.boardSpec.columns =
				TrackingFactory.buildColumnSpecListFromXML(xml.spec.col, model.boardSpec.colorMaps);
				
			//build display properties
			model.boardSpec.displayBoardProperties =
    			TrackingFactory.buildDisplayBoardPropertiesFromXML(xml.spec.displayProperties);

			// build the row spec			
			model.boardSpec.rowColorMap =
				BoardTools.locateColorMap(xml.spec.row.@color, model.boardSpec.colorMaps);

			// load the actual data for the board
			model.boardData = new XMLListCollection(xml.rows.children() as XMLList);
			
			model.bigboardInfo = new BigBoardDebugInfo();
			model.bigboardInfo.bigBoardSiteCode = xml.vistalinkConnectionInfo.siteId;
			model.bigboardInfo.bigBoardMachineName = xml.vistalinkConnectionInfo.machineName;	
			model.bigboardInfo.vistaLinkIPAddress = xml.vistalinkConnectionInfo.vistalinkIPAddress;
			model.bigboardInfo.vistaLinkPort = xml.vistalinkConnectionInfo.vistalinkPort;			
			
			model.boardSpec.specReady = true;
			
			model.boardLastUpdated = new Date();
			model.boardReady = true;
			
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Initialize display board failed: " + super.getFaultMessage(faultEvent);
		}
	}
}