/* LoadConfigStaffCommand.as */
	
package gov.va.med.edp.command.config
{
	import com.adobe.cairngorm.commands.ICommand;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import gov.va.med.edp.business.config.LoadConfigStaffDelegate;
	import gov.va.med.edp.command.AbstractResponderCommand;
	import gov.va.med.edp.util.BoardTools;
	import gov.va.med.edp.model.TrackingModelLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;

	public class LoadConfigStaffCommand extends AbstractResponderCommand implements ICommand, IResponder
	{
		private var model:TrackingModelLocator = TrackingModelLocator.getInstance();
				
		public function execute(event:CairngormEvent):void
		{
			var delegate: LoadConfigStaffDelegate = new LoadConfigStaffDelegate(this);
			model.config.staffConfigLoaded = false;
			delegate.loadConfigStaff(model.logArea);
		}
		
		public override function result(data:Object):void
		{
			var xml:XML = ResultEvent(data).result as XML;
			BoardTools.applyStaffLists(model.config, xml);
			model.config.staffConfigLoaded = true;
		}
		
		protected override function getFaultMessage(faultEvent:FaultEvent):String {
			return "Error loading configuration for staff: " + super.getFaultMessage(faultEvent);
		}		
	}
}